/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;
import adams.parser.GrammarSupplier;
import adams.parser.SpreadSheetQueryText;
import java.util.HashMap;

public class SpreadSheetQuery
extends AbstractSpreadSheetTransformer
implements GrammarSupplier {
    private static final long serialVersionUID = -4633161214275622241L;
    protected SpreadSheetQueryText m_Query;

    public String globalInfo() {
        return "Applies a query (SELECT, UPDATE, DELETE) on a spreadsheet.\nVariables are supported as well, e.g., : SELECT * WHERE Blah = @{val}  with 'val' being a variable available at execution time.\nThe following grammar is used for the query:\n\n" + this.getGrammar();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("query", "query", (Object)new SpreadSheetQueryText("SELECT *"));
    }

    public String getGrammar() {
        return new adams.parser.SpreadSheetQuery().getGrammar();
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"query", (Object)Utils.shorten((String)this.m_Query.getValue().replaceAll("\\s+", " "), (int)50));
    }

    public void setQuery(SpreadSheetQueryText value) {
        this.m_Query = value;
        this.reset();
    }

    public SpreadSheetQueryText getQuery() {
        return this.m_Query;
    }

    public String queryTipText() {
        return "The query to execute.";
    }

    protected String doExecute() {
        String result = null;
        String query = this.m_Query.getValue();
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Query: " + query);
        }
        query = this.getVariables().expand(query);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("--> expanded: " + query);
        }
        SpreadSheet sheet = null;
        try {
            sheet = adams.parser.SpreadSheetQuery.evaluate(query, new HashMap(), (SpreadSheet)this.m_InputToken.getPayload());
        }
        catch (Exception e) {
            result = this.handleException("Failed to evaluate query: " + query, e);
        }
        if (sheet != null) {
            this.m_OutputToken = new Token((Object)sheet);
        }
        return result;
    }
}

