/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv;

import adams.data.Notes;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.BoofCVImageType;
import adams.data.image.AbstractImageContainer;
import adams.data.report.Report;
import boofcv.core.image.ConvertBufferedImage;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import java.awt.image.BufferedImage;

public class BoofCVHelper {
    public static BufferedImage toBufferedImage(ImageBase img) {
        if (ImageUInt8.class == img.getClass()) {
            return VisualizeBinaryData.renderBinary((ImageUInt8)((ImageUInt8)img), null);
        }
        return ConvertBufferedImage.convertTo((ImageBase)img, null, (boolean)true);
    }

    public static ImageBase clone(ImageBase img) {
        if (img instanceof ImageSingleBand) {
            return ((ImageSingleBand)img).clone();
        }
        return img.subimage(0, 0, img.getWidth() - 1, img.getHeight() - 1, null);
    }

    public static ImageBase toBoofCVImage(ImageBase img, BoofCVImageType type) {
        if (img.getClass() == type.getImageClass()) {
            return img;
        }
        return BoofCVHelper.toBoofCVImage(BoofCVHelper.toBufferedImage(img), type);
    }

    public static ImageBase toBoofCVImage(BufferedImage img) {
        switch (img.getType()) {
            case 12: {
                return BoofCVHelper.toBoofCVImage(img, BoofCVImageType.UNSIGNED_INT_8);
            }
            case 10: {
                return BoofCVHelper.toBoofCVImage(img, BoofCVImageType.UNSIGNED_INT_8);
            }
        }
        return BoofCVHelper.toBoofCVImage(img, BoofCVImageType.FLOAT_32);
    }

    public static ImageBase toBoofCVImage(BufferedImage img, BoofCVImageType type) {
        return ConvertBufferedImage.convertFromSingle((BufferedImage)img, null, (Class)type.getImageClass());
    }

    public static ImageBase toBoofCVImage(AbstractImageContainer cont, BoofCVImageType type) {
        if (cont instanceof BoofCVImageContainer) {
            return BoofCVHelper.toBoofCVImage((ImageBase)((BoofCVImageContainer)cont).getImage(), type);
        }
        return BoofCVHelper.toBoofCVImage(cont.toBufferedImage(), type);
    }

    public static BoofCVImageContainer toBoofCVImageContainer(AbstractImageContainer cont) {
        if (cont instanceof BoofCVImageContainer) {
            return (BoofCVImageContainer)cont;
        }
        return BoofCVHelper.toBoofCVImageContainer(cont, BoofCVImageType.FLOAT_32);
    }

    public static BoofCVImageContainer toBoofCVImageContainer(AbstractImageContainer cont, BoofCVImageType type) {
        BoofCVImageContainer result;
        if (cont instanceof BoofCVImageContainer) {
            if (((ImageBase)((BoofCVImageContainer)cont).getImage()).getClass() == type.getImageClass()) {
                result = (BoofCVImageContainer)cont;
            } else {
                result = (BoofCVImageContainer)cont.getHeader();
                result.setImage(BoofCVHelper.toBoofCVImage((ImageBase)((BoofCVImageContainer)cont).getImage(), type));
            }
        } else {
            Report report = cont.getReport().getClone();
            Notes notes = cont.getNotes().getClone();
            result = new BoofCVImageContainer();
            if (cont.getImage() instanceof ImageBase) {
                result.setImage(BoofCVHelper.toBoofCVImage((ImageBase)cont.getImage(), type));
            } else {
                result.setImage(BoofCVHelper.toBoofCVImage(cont.toBufferedImage(), type));
            }
            result.setReport(report);
            result.setNotes(notes);
        }
        return result;
    }
}

