/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagemagick.im;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.imagemagick.im.AbstractIMSimpleOperation;
import org.im4java.core.IMOperation;

public class AdaptiveSharpen
extends AbstractIMSimpleOperation {
    private static final long serialVersionUID = 3529048936510645338L;
    protected double m_Radius;
    protected double m_Sigma;

    public String globalInfo() {
        return "Adaptive sharpen (option -adaptive-sharpen)";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("radius", "radius", (Object)1.0, (Number)0.0, null);
        this.m_OptionManager.add("sigma", "sigma", (Object)0.0, (Number)0.0, null);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"radius", (Object)this.m_Radius, (String)"radius: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"sigma", (Object)this.m_Sigma, (String)", sigma: ");
        return result;
    }

    public void setRadius(double value) {
        if (value > 0.0) {
            this.m_Radius = value;
            this.reset();
        } else {
            this.getLogger().warning("Radius must be > 0, provided: " + value);
        }
    }

    public double getRadius() {
        return this.m_Radius;
    }

    public String radiusTipText() {
        return "The radius of the Gaussian in pixels.";
    }

    public void setSigma(double value) {
        if (value >= 0.0) {
            this.m_Sigma = value;
            this.reset();
        } else {
            this.getLogger().warning("Sigma must be >= 0, provided: " + value);
        }
    }

    public double getSigma() {
        return this.m_Sigma;
    }

    public String sigmaTipText() {
        return "The sigma of the Gaussian in pixels; 0 for 'automagic'.";
    }

    @Override
    protected String check(PlaceholderFile input, PlaceholderFile output) {
        if (this.m_Sigma > 0.0 && this.m_Radius == 0.0) {
            return "A radius must be supplied if sigma is >0.";
        }
        return super.check(input, output);
    }

    @Override
    protected void addOperation(IMOperation op) {
        if (this.m_Sigma == 0.0) {
            if (this.m_Radius == 0.0) {
                op.adaptiveSharpen();
            } else {
                op.adaptiveSharpen(Double.valueOf(this.m_Radius));
            }
        } else {
            op.adaptiveSharpen(Double.valueOf(this.m_Radius), Double.valueOf(this.m_Sigma));
        }
    }
}

