/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.image.BufferedImageContainer;
import adams.data.imagemagick.ImageMagickHelper;
import adams.data.imagemagick.ImageType;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.output.AbstractImageWriter;
import adams.data.io.output.ImageMagickImageWriter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

public class ImageMagickImageReader
extends AbstractImageReader<BufferedImageContainer> {
    private static final long serialVersionUID = 5347100846354068540L;

    public String globalInfo() {
        return "ImageMagick image reader for: " + Utils.flatten((Object[])this.getFormatExtensions(), (String)", ") + "\n" + "\n" + "For more information see:\n" + "http://www.imagemagick.org/\n" + (ImageMagickHelper.isConvertAvailable() ? "" : "\n" + ImageMagickHelper.getMissingConvertErrorMessage());
    }

    public String getFormatDescription() {
        return "ImageMagick";
    }

    public String[] getFormatExtensions() {
        ArrayList<String> result = new ArrayList<String>();
        for (ImageType it : ImageType.values()) {
            if (it == ImageType.AUTO || !it.canRead()) continue;
            result.add(it.getExtension());
        }
        Collections.sort(result);
        return result.toArray(new String[result.size()]);
    }

    public AbstractImageWriter getCorrespondingWriter() {
        return new ImageMagickImageWriter();
    }

    public boolean isAvailable() {
        return ImageMagickHelper.isConvertAvailable();
    }

    protected void check(PlaceholderFile file) {
        super.check(file);
        if (!ImageMagickHelper.isConvertAvailable()) {
            throw new IllegalStateException(ImageMagickHelper.getMissingConvertErrorMessage());
        }
    }

    protected BufferedImageContainer doRead(PlaceholderFile file) {
        BufferedImageContainer result = null;
        BufferedImage image = ImageMagickHelper.read((File)file);
        if (image != null) {
            result = new BufferedImageContainer();
            result.setImage((Object)image);
        }
        return result;
    }
}

