/*
 * Decompiled with CFR 0.152.
 */
package adams.data.tesseract;

import adams.core.Properties;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOption;
import adams.env.Environment;
import adams.flow.core.TesseractLanguage;
import adams.flow.core.TesseractPageSegmentation;
import java.util.ArrayList;

public class TesseractHelper {
    public static final String FILENAME = "Tesseract.props";
    public static final String EXECUTABLE = "Executable";
    public static final String LANGUAGE = "Language";
    protected static TesseractHelper m_Singleton;
    protected Properties m_Properties;
    protected boolean m_Modified;

    private TesseractHelper() {
        this.reload();
    }

    public boolean isModified() {
        return this.m_Modified;
    }

    public String getExecutable() {
        return this.m_Properties.getProperty(EXECUTABLE, "");
    }

    public void setExecutable(String value) {
        this.m_Modified = true;
        this.m_Properties.setProperty(EXECUTABLE, value);
    }

    public TesseractLanguage getLanguage() {
        return TesseractLanguage.valueOf((AbstractOption)null, this.m_Properties.getProperty(LANGUAGE, TesseractLanguage.ENGLISH.toRaw()));
    }

    public void setLanguage(TesseractLanguage value) {
        this.m_Modified = true;
        this.m_Properties.setProperty(LANGUAGE, value.toRaw());
    }

    public synchronized void reload() {
        this.m_Modified = false;
        try {
            this.m_Properties = Environment.getInstance().read("tesseract");
        }
        catch (Exception e) {
            this.m_Properties = new Properties();
        }
    }

    public synchronized boolean save() {
        boolean result = Environment.getInstance().write("tesseract", this.m_Properties);
        if (result) {
            this.m_Modified = false;
        }
        return result;
    }

    public String[] getCommand(String input, String outputbase, PlaceholderFile config) {
        return this.getCommand(null, input, outputbase, null, null, config, false);
    }

    public String[] getCommand(String exe, String input, String outputbase, TesseractLanguage lang, TesseractPageSegmentation seg, PlaceholderFile config, boolean hocr) {
        if (exe == null) {
            exe = this.getExecutable();
        }
        if (lang == null) {
            lang = this.getLanguage();
        }
        if (seg == null) {
            seg = TesseractPageSegmentation.FULL_AUTO_NO_OSD;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(exe);
        result.add(input);
        result.add(outputbase);
        result.add("-l");
        result.add(lang.toCode());
        result.add("-psm");
        result.add("" + seg.toCode());
        if (config != null && config.exists() && !config.isDirectory()) {
            result.add(config.getAbsolutePath());
        }
        if (hocr) {
            result.add("hocr");
        }
        return result.toArray(new String[result.size()]);
    }

    public static synchronized TesseractHelper getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new TesseractHelper();
        }
        return m_Singleton;
    }
}

