/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.data.image.transformer.PassThrough;
import adams.data.jai.JAIHelper;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;

public class BufferedImageTransformer
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 3690378527551302472L;
    public static final String BACKUP_CURRENTIMAGES = "current images";
    protected AbstractBufferedImageTransformer m_TransformAlgorithm;
    protected List<BufferedImageContainer> m_CurrentImages;

    public String globalInfo() {
        return "Applies a BufferedImage transformation to the incoming image and outputs the generated image(s).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("transformer", "transformAlgorithm", (Object)new PassThrough());
    }

    protected void initialize() {
        super.initialize();
        this.m_CurrentImages = new ArrayList<BufferedImageContainer>();
    }

    public void setTransformAlgorithm(AbstractBufferedImageTransformer value) {
        this.m_TransformAlgorithm = value;
        this.reset();
    }

    public AbstractBufferedImageTransformer getTransformAlgorithm() {
        return this.m_TransformAlgorithm;
    }

    public String transformAlgorithmTipText() {
        return "The transformer to use for transformering the image.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"transformAlgorithm", (Object)((Object)this.m_TransformAlgorithm));
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    public Class[] generates() {
        return new Class[]{BufferedImageContainer.class};
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CURRENTIMAGES);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_CURRENTIMAGES, this.m_CurrentImages);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CURRENTIMAGES)) {
            this.m_CurrentImages = (List)state.get(BACKUP_CURRENTIMAGES);
            state.remove(BACKUP_CURRENTIMAGES);
        }
        super.restoreState(state);
    }

    protected String doExecute() {
        String result = null;
        try {
            BufferedImageContainer img = JAIHelper.toBufferedImageContainer((AbstractImageContainer)this.m_InputToken.getPayload());
            this.m_CurrentImages = new ArrayList<AbstractImageContainer>(Arrays.asList(this.m_TransformAlgorithm.transform((AbstractImageContainer)img)));
        }
        catch (Exception e) {
            result = this.handleException("Failed to transform image: ", e);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_CurrentImages.size() > 0;
    }

    public Token output() {
        Token result = new Token((Object)this.m_CurrentImages.get(0));
        this.m_CurrentImages.remove(0);
        this.updateProvenance((ProvenanceContainer)result);
        return result;
    }

    public void wrapUp() {
        this.m_CurrentImages.clear();
        super.wrapUp();
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, ((Token)cont).getPayload().getClass()));
        }
    }
}

