/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.JAIImageReader;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class ImageReader
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 7466006970025235243L;
    protected AbstractImageReader m_Reader;

    public String globalInfo() {
        return "Reads any file format that the specified image reader supports.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)new JAIImageReader());
    }

    public void setReader(AbstractImageReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public AbstractImageReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The image reader to use.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{AbstractImageContainer.class};
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"reader", (Object)this.m_Reader);
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && !this.m_Reader.isAvailable()) {
            result = "Reader '" + this.m_Reader.getClass().getName() + "' is not available - check setup!";
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        PlaceholderFile file = this.m_InputToken.getPayload() instanceof String ? new PlaceholderFile((String)this.m_InputToken.getPayload()) : new PlaceholderFile((File)this.m_InputToken.getPayload());
        try {
            AbstractImageContainer cont = this.m_Reader.read(file);
            if (cont != null) {
                this.m_OutputToken = new Token((Object)cont);
            } else {
                result = "Failed to read image: " + file;
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to read image: " + file, e);
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

