/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.locateobjects;

import adams.core.CleanUpHandler;
import adams.core.QuickInfoSupporter;
import adams.core.Stoppable;
import adams.core.option.AbstractOptionHandler;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractObjectLocator
extends AbstractOptionHandler
implements Stoppable,
CleanUpHandler,
QuickInfoSupporter {
    private static final long serialVersionUID = -4035633099365011707L;
    protected boolean m_CenterOnCanvas;
    protected int m_CanvasWidth;
    protected int m_CanvasHeight;
    protected Color m_CanvasColor;
    protected List<String> m_Errors;
    protected List<String> m_Warnings;
    protected boolean m_Stopped;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("center-on-canvas", "centerOnCanvas", (Object)this.getDefaultCenterOnCanvas());
        this.m_OptionManager.add("canvas-width", "canvasWidth", (Object)this.getDefaultCanvasWidth(), (Number)1, null);
        this.m_OptionManager.add("canvas-height", "canvasHeight", (Object)this.getDefaultCanvasHeight(), (Number)1, null);
        this.m_OptionManager.add("canvas-color", "canvasColor", (Object)this.getDefaultCanvasColor());
    }

    protected void initialize() {
        super.initialize();
        this.m_Errors = new ArrayList<String>();
        this.m_Warnings = new ArrayList<String>();
    }

    protected void reset() {
        super.reset();
        this.m_Errors.clear();
        this.m_Warnings.clear();
    }

    protected boolean getDefaultCenterOnCanvas() {
        return false;
    }

    public void setCenterOnCanvas(boolean value) {
        this.m_CenterOnCanvas = value;
        this.reset();
    }

    public boolean getCenterOnCanvas() {
        return this.m_CenterOnCanvas;
    }

    public String centerOnCanvasTipText() {
        return "If enabled, the located objects get centered on a canvas of fixed size.";
    }

    protected int getDefaultCanvasWidth() {
        return 100;
    }

    public void setCanvasWidth(int value) {
        this.m_CanvasWidth = value;
        this.reset();
    }

    public int getCanvasWidth() {
        return this.m_CanvasWidth;
    }

    public String canvasWidthTipText() {
        return "The width of the canvas in pixels.";
    }

    protected int getDefaultCanvasHeight() {
        return 100;
    }

    public void setCanvasHeight(int value) {
        this.m_CanvasHeight = value;
        this.reset();
    }

    public int getCanvasHeight() {
        return this.m_CanvasHeight;
    }

    public String canvasHeightTipText() {
        return "The height of the canvas in pixels.";
    }

    protected Color getDefaultCanvasColor() {
        return Color.WHITE;
    }

    public void setCanvasColor(Color value) {
        this.m_CanvasColor = value;
        this.reset();
    }

    public Color getCanvasColor() {
        return this.m_CanvasColor;
    }

    public String canvasColorTipText() {
        return "The color to use for filling the canvas.";
    }

    public String getQuickInfo() {
        return null;
    }

    public boolean hasErrors() {
        return this.m_Errors.size() > 0;
    }

    public List<String> getErrors() {
        return this.m_Errors;
    }

    protected void addError(String msg) {
        this.m_Errors.add(msg);
    }

    public boolean hasWarnings() {
        return this.m_Warnings.size() > 0;
    }

    public List<String> getWarnings() {
        return this.m_Warnings;
    }

    protected void addWarning(String msg) {
        this.m_Warnings.add(msg);
    }

    protected void check(BufferedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("No image provided!");
        }
    }

    protected BufferedImage centerOnCanvas(BufferedImage img) {
        int sy2;
        int sy1;
        int dy2;
        int dy1;
        int sx2;
        int sx1;
        int dx2;
        int dx1;
        BufferedImage result = new BufferedImage(this.m_CanvasWidth, this.m_CanvasHeight, 2);
        Graphics2D g = result.createGraphics();
        g.setColor(this.m_CanvasColor);
        g.fillRect(0, 0, this.m_CanvasWidth, this.m_CanvasHeight);
        if (result.getWidth() >= img.getWidth()) {
            dx1 = (result.getWidth() - img.getWidth()) / 2;
            dx2 = dx1 + img.getWidth() - 1;
            sx1 = 0;
            sx2 = sx1 + img.getWidth() - 1;
        } else {
            dx1 = 0;
            dx2 = dx1 + result.getWidth() - 1;
            sx1 = (img.getWidth() - result.getWidth()) / 2;
            sx2 = sx1 + result.getWidth() - 1;
        }
        if (result.getHeight() >= img.getHeight()) {
            dy1 = (result.getHeight() - img.getHeight()) / 2;
            dy2 = dy1 + img.getHeight() - 1;
            sy1 = 0;
            sy2 = sy1 + img.getHeight() - 1;
        } else {
            dy1 = 0;
            dy2 = dy1 + result.getHeight() - 1;
            sy1 = (img.getHeight() - result.getHeight()) / 2;
            sy2 = sy1 + result.getHeight() - 1;
        }
        g.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
        g.dispose();
        return result;
    }

    protected abstract LocatedObjects doLocate(BufferedImage var1);

    public LocatedObjects locate(BufferedImage image) {
        this.m_Stopped = false;
        this.m_Errors.clear();
        this.m_Warnings.clear();
        this.check(image);
        LocatedObjects result = this.doLocate(image);
        if (this.m_Stopped) {
            result = new LocatedObjects();
        } else if (this.m_CenterOnCanvas) {
            for (int i = 0; i < result.size(); ++i) {
                LocatedObject current = (LocatedObject)result.get(i);
                BufferedImage img = this.centerOnCanvas(current.getImage());
                LocatedObject updated = new LocatedObject(img, current.getX(), current.getY(), current.getWidth(), current.getHeight());
                result.set(i, updated);
            }
        }
        return result;
    }

    public void stopExecution() {
        this.m_Stopped = true;
    }

    public void cleanUp() {
        this.reset();
    }

    public void destroy() {
        this.cleanUp();
        super.destroy();
    }
}

