/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.locateobjects;

import adams.core.License;
import adams.core.QuickInfoHelper;
import adams.core.annotation.MixedCopyright;
import adams.core.option.OptionHandler;
import adams.flow.transformer.locateobjects.AbstractObjectLocator;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.filter.binary.Contour;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.core.image.ConvertBufferedImage;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.point.Point2D_I32;
import java.awt.image.BufferedImage;
import java.util.List;

@MixedCopyright(author="Peter Abeles", license=License.APACHE2, url="https://github.com/lessthanoptimal/BoofCV/blob/v0.15/examples/src/boofcv/examples/ExampleFitEllipse.java", note="Code taken from this BoofCV example")
public class BinaryContours
extends AbstractObjectLocator {
    private static final long serialVersionUID = 9160763275489359825L;
    protected boolean m_RemoveSmallBlobs;

    public String globalInfo() {
        return "Uses the BoofCV contour-finding algorithm to locate objects.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remove-small-blobs", "removeSmallBlobs", (Object)false);
    }

    public void setRemoveSmallBlobs(boolean value) {
        this.m_RemoveSmallBlobs = value;
        this.reset();
    }

    public boolean getRemoveSmallBlobs() {
        return this.m_RemoveSmallBlobs;
    }

    public String removeSmallBlobsTipText() {
        return "If enabled, small blobs are removed using erode8/dilate8.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"removeSmallBlobs", (boolean)this.m_RemoveSmallBlobs, (String)"remove small blobs");
    }

    @Override
    protected LocatedObjects doLocate(BufferedImage image) {
        ImageUInt8 filtered;
        ImageFloat32 input = (ImageFloat32)ConvertBufferedImage.convertFromSingle((BufferedImage)image, null, ImageFloat32.class);
        ImageUInt8 binary = new ImageUInt8(input.width, input.height);
        double mean = ImageStatistics.mean((ImageFloat32)input);
        ThresholdImageOps.threshold((ImageFloat32)input, (ImageUInt8)binary, (float)((float)mean), (boolean)true);
        if (this.m_RemoveSmallBlobs) {
            filtered = BinaryImageOps.erode8((ImageUInt8)binary, (int)1, null);
            filtered = BinaryImageOps.dilate8((ImageUInt8)filtered, (int)1, null);
        } else {
            filtered = binary;
        }
        List contours = BinaryImageOps.contour((ImageUInt8)filtered, (ConnectRule)ConnectRule.EIGHT, null);
        LocatedObjects result = new LocatedObjects();
        for (Contour contour : contours) {
            int left = image.getWidth();
            int right = 0;
            int top = image.getHeight();
            int bottom = 0;
            for (Point2D_I32 p : contour.external) {
                if (left > p.getX()) {
                    left = p.getX();
                }
                if (right < p.getX()) {
                    right = p.getX();
                }
                if (top > p.getY()) {
                    top = p.getY();
                }
                if (bottom >= p.getY()) continue;
                bottom = p.getY();
            }
            result.add(new LocatedObject(image.getSubimage(left, top, right - left + 1, bottom - top + 1), left, top, right - left + 1, bottom - top + 1));
        }
        return result;
    }
}

