/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.locateobjects;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.transformer.locateobjects.AbstractMetaObjectLocator;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.image.BufferedImage;

public class SizeFilter
extends AbstractMetaObjectLocator {
    private static final long serialVersionUID = 7548064590836834398L;
    protected int m_MinWidth;
    protected int m_MaxWidth;
    protected int m_MinHeight;
    protected int m_MaxHeight;

    public String globalInfo() {
        return "Allows filtering the located objects based on the min/max width/height.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-width", "minWidth", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("max-width", "maxWidth", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("min-height", "minHeight", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("max-height", "maxHeight", (Object)-1, (Number)-1, null);
    }

    public void setMinWidth(int value) {
        if (value >= -1) {
            this.m_MinWidth = value;
            this.reset();
        } else {
            this.getLogger().warning("Minimum width must be at least -1, provided: " + value);
        }
    }

    public int getMinWidth() {
        return this.m_MinWidth;
    }

    public String minWidthTipText() {
        return "The minimum width; ignored if <= 0.";
    }

    public void setMaxWidth(int value) {
        if (value >= -1) {
            this.m_MaxWidth = value;
            this.reset();
        } else {
            this.getLogger().warning("Maximum width must be at least -1, provided: " + value);
        }
    }

    public int getMaxWidth() {
        return this.m_MaxWidth;
    }

    public String maxWidthTipText() {
        return "The maximum width; ignored if <= 0.";
    }

    public void setMinHeight(int value) {
        if (value >= -1) {
            this.m_MinHeight = value;
            this.reset();
        } else {
            this.getLogger().warning("Minimum height must be at least -1, provided: " + value);
        }
    }

    public int getMinHeight() {
        return this.m_MinHeight;
    }

    public String minHeightTipText() {
        return "The minimum height; ignored if <= 0.";
    }

    public void setMaxHeight(int value) {
        if (value >= -1) {
            this.m_MaxHeight = value;
            this.reset();
        } else {
            this.getLogger().warning("Maximum height must be at least -1, provided: " + value);
        }
    }

    public int getMaxHeight() {
        return this.m_MaxHeight;
    }

    public String maxHeightTipText() {
        return "The maximum height; ignored if <= 0.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"minWidth", (Object)(this.m_MinWidth < 1 ? "NA" : "" + this.m_MinWidth), (String)"minW: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"maxWidth", (Object)(this.m_MaxWidth < 1 ? "NA" : "" + this.m_MaxWidth), (String)", maxW: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"minHeight", (Object)(this.m_MinHeight < 1 ? "NA" : "" + this.m_MinHeight), (String)"minH: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"maxHeight", (Object)(this.m_MaxHeight < 1 ? "NA" : "" + this.m_MaxHeight), (String)", maxH: ");
        return result;
    }

    @Override
    protected LocatedObjects doLocate(BufferedImage image) {
        LocatedObjects result = new LocatedObjects();
        LocatedObjects base = this.m_Locator.locate(image);
        for (LocatedObject obj : base) {
            if (this.m_MinWidth > 0 && obj.getWidth() < this.m_MinWidth || this.m_MaxWidth > 0 && obj.getWidth() > this.m_MaxWidth || this.m_MinHeight > 0 && obj.getHeight() < this.m_MinHeight || this.m_MaxHeight > 0 && obj.getHeight() > this.m_MaxHeight) continue;
            result.add(obj);
        }
        return result;
    }
}

