/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pixelselector;

import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.flow.transformer.pixelselector.AbstractSingleColorPixelSelectorOverlay;
import adams.flow.transformer.pixelselector.AddClassification;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class ClassificationOverlay
extends AbstractSingleColorPixelSelectorOverlay {
    private static final long serialVersionUID = 5524667354695674686L;
    protected boolean m_ShowIndex;
    protected boolean m_ShowLabel;

    @Override
    protected String getGlobalInfo() {
        return "Highlights the chosen classifications.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("show-index", "showIndex", (Object)false);
        this.m_OptionManager.add("show-label", "showLabel", (Object)false);
    }

    public void setShowIndex(boolean value) {
        this.m_ShowIndex = value;
        this.reset();
    }

    public boolean getShowIndex() {
        return this.m_ShowIndex;
    }

    public String showIndexTipText() {
        return "If enabled, the index is shown as part of the text accompanying the location of the pixel.";
    }

    public void setShowLabel(boolean value) {
        this.m_ShowLabel = value;
        this.reset();
    }

    public boolean getShowLabel() {
        return this.m_ShowLabel;
    }

    public String showLabelTipText() {
        return "If enabled, the classification label is shown as part of the text accompanying the location of the pixel.";
    }

    public void imageChanged(ImagePanel.PaintPanel panel) {
    }

    @Override
    public Class[] getSuggestedActions() {
        return new Class[]{AddClassification.class};
    }

    protected Integer[] getClassificationIndices() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List fields = this.m_Image.getReport().getFields();
        for (AbstractField field : fields) {
            if (!field.getName().startsWith("Classification.")) continue;
            result.add(Integer.parseInt(field.getName().substring("Classification.".length())));
        }
        return result.toArray(new Integer[result.size()]);
    }

    protected Point getPixelLocation(int index) {
        Report report;
        Point result = null;
        if (this.m_Image != null && this.m_Image.hasReport() && (report = this.m_Image.getReport()).hasValue("Pixel.X." + index) && report.hasValue("Pixel.Y." + index)) {
            result = new Point(report.getDoubleValue("Pixel.X." + index).intValue(), report.getDoubleValue("Pixel.Y." + index).intValue());
        }
        return result;
    }

    @Override
    protected void doPaintOverlay(ImagePanel.PaintPanel panel, Graphics g) {
        Integer[] indices = this.getClassificationIndices();
        if (indices.length == 0) {
            return;
        }
        for (Integer index : indices) {
            Point loc = this.getPixelLocation(index);
            if (loc == null) continue;
            g.setColor(this.m_Color);
            int x = (int)loc.getX() - 1;
            int y = (int)loc.getY() - 1;
            g.drawRect(x, y, 3, 3);
            if (!this.m_ShowIndex && !this.m_ShowLabel) continue;
            StringBuilder str = new StringBuilder();
            if (this.m_ShowIndex) {
                str.append("" + index);
            }
            String label = this.m_Image.getReport().getStringValue("Classification." + index);
            if (this.m_ShowLabel && label != null) {
                if (str.length() > 0) {
                    str.append(": ");
                }
                str.append(label);
            }
            if (str.length() <= 0) continue;
            g.drawString(str.toString(), x + 5, y);
        }
    }
}

