/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.core.option.OptionUtils;
import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.features.AbstractBoofCVFeatureGenerator;
import adams.data.boofcv.features.Histogram;
import adams.data.featureconverter.AbstractFeatureConverter;
import adams.data.featureconverter.SpreadSheet;
import adams.data.spreadsheet.Row;
import adams.gui.visualization.image.plugins.AbstractSelectedImagesFeatureGenerator;
import java.awt.image.BufferedImage;

public class BoofCVFeatureGenerator
extends AbstractSelectedImagesFeatureGenerator {
    private static final long serialVersionUID = -3146372359577147914L;

    public String getCaption() {
        return "BoofCV feature generator...";
    }

    public String getIconName() {
        return "boofcv.png";
    }

    protected Class getEditorType() {
        return AbstractBoofCVFeatureGenerator.class;
    }

    protected Object getDefaultValue() {
        return new Histogram();
    }

    protected String createLogEntry() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + OptionUtils.getCommandLine((Object)this.m_Editor.getValue());
    }

    @Override
    protected Row[] generateFeatures(BufferedImage image) {
        Row[] result = null;
        this.setLastSetup(this.m_Editor.getValue());
        AbstractBoofCVFeatureGenerator generator = (AbstractBoofCVFeatureGenerator)this.m_Editor.getValue();
        generator.setConverter((AbstractFeatureConverter)new SpreadSheet());
        BoofCVImageContainer input = new BoofCVImageContainer();
        input.setImage(BoofCVHelper.toBoofCVImage(image));
        Row[] features = (Row[])generator.generate(input);
        if (features.length == 0) {
            this.m_FilterError = "No features generated!";
        }
        if (features.length > 0) {
            result = features;
        }
        return result;
    }
}

