/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.core.option.OptionUtils;
import adams.data.featureconverter.AbstractFeatureConverter;
import adams.data.featureconverter.SpreadSheet;
import adams.data.image.BufferedImageContainer;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.jai.features.Histogram;
import adams.data.spreadsheet.Row;
import adams.gui.visualization.image.plugins.AbstractSelectedImagesFeatureGenerator;
import java.awt.image.BufferedImage;

public class BufferedImageFeatureGenerator
extends AbstractSelectedImagesFeatureGenerator {
    private static final long serialVersionUID = -3146372359577147914L;

    public String getCaption() {
        return "BufferedImage feature generator...";
    }

    public String getIconName() {
        return "duke.png";
    }

    protected Class getEditorType() {
        return AbstractBufferedImageFeatureGenerator.class;
    }

    protected Object getDefaultValue() {
        return new Histogram();
    }

    protected String createLogEntry() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + OptionUtils.getCommandLine((Object)this.m_Editor.getValue());
    }

    @Override
    protected Row[] generateFeatures(BufferedImage image) {
        Row[] result = null;
        this.setLastSetup(this.m_Editor.getValue());
        AbstractBufferedImageFeatureGenerator generator = (AbstractBufferedImageFeatureGenerator)this.m_Editor.getValue();
        generator.setConverter((AbstractFeatureConverter)new SpreadSheet());
        BufferedImageContainer input = new BufferedImageContainer();
        input.setImage((Object)image);
        Row[] features = (Row[])generator.generate(input);
        if (features.length == 0) {
            this.m_FilterError = "No features generated!";
        }
        if (features.length > 0) {
            result = features;
        }
        return result;
    }
}

