/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.core.option.OptionUtils;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.data.image.transformer.PassThrough;
import adams.gui.visualization.image.plugins.AbstractSelectedImagesFilterWithGOE;
import java.awt.image.BufferedImage;

public class BufferedImageTransformer
extends AbstractSelectedImagesFilterWithGOE {
    private static final long serialVersionUID = -3146372359577147914L;

    public String getCaption() {
        return "BufferedImage transformer...";
    }

    public String getIconName() {
        return "duke.png";
    }

    protected Class getEditorType() {
        return AbstractBufferedImageTransformer.class;
    }

    protected Object getDefaultValue() {
        return new PassThrough();
    }

    protected String createLogEntry() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + OptionUtils.getCommandLine((Object)this.m_Editor.getValue());
    }

    protected BufferedImage filter(BufferedImage image) {
        BufferedImage result = null;
        this.setLastSetup(this.m_Editor.getValue());
        AbstractBufferedImageTransformer transformer = (AbstractBufferedImageTransformer)((Object)this.m_Editor.getValue());
        BufferedImageContainer input = new BufferedImageContainer();
        input.setImage((Object)image);
        BufferedImageContainer[] transformed = (BufferedImageContainer[])transformer.transform((AbstractImageContainer)input);
        if (transformed.length == 0) {
            this.m_FilterError = "No filtered image generated!";
        }
        if (transformed.length > 1) {
            this.getLogger().warning("Generated more than one image, using only first one.");
        }
        if (transformed.length >= 1) {
            result = (BufferedImage)transformed[0].getImage();
        }
        return result;
    }
}

