/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.DateFormat;
import adams.core.DateTime;
import adams.core.Time;
import adams.core.management.LocaleHelper;
import adams.data.DateFormatString;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    protected static TimeZone m_TimeZone = TimeZone.getDefault();
    protected static Locale m_Locale = LocaleHelper.getSingleton().getDefault();

    public static synchronized void setTimeZone(TimeZone value) {
        m_TimeZone = value;
    }

    public static synchronized TimeZone getTimeZone() {
        return m_TimeZone;
    }

    public static synchronized void setLocale(Locale value) {
        m_Locale = value;
    }

    public static synchronized Locale getLocale() {
        return m_Locale;
    }

    public static synchronized Calendar getCalendar() {
        return new GregorianCalendar(DateUtils.getTimeZone(), DateUtils.getLocale());
    }

    public static DateFormat getTimestampFormatter() {
        return new DateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static DateFormat getTimestampFormatterMsecs() {
        return new DateFormat("yyyy-MM-dd HH:mm:ss.S");
    }

    public static DateFormat getTimeFormatter() {
        return new DateFormat("HH:mm:ss");
    }

    public static DateFormat getTimeFormatterMsecs() {
        return new DateFormat("HH:mm:ss.S");
    }

    public static DateFormat getDateFormatter() {
        return new DateFormat("yyyy-MM-dd");
    }

    public static boolean isValid(String pattern) {
        try {
            new SimpleDateFormat(pattern);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Date earlier(Date date, int type, int decrement) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        cal.add(type, -Math.abs(decrement));
        return cal.getTime();
    }

    public static Date later(Date date, int type, int increment) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        cal.add(type, Math.abs(increment));
        return cal.getTime();
    }

    public static Date set(Date date, int type, int value) {
        Date result;
        Calendar cal = DateUtils.getCalendar();
        cal.setLenient(false);
        cal.setTime(date);
        try {
            cal.set(type, value);
            result = cal.getTime();
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static boolean isBefore(Date base, Date check) {
        return base.compareTo(check) > 0;
    }

    public static boolean isAfter(Date base, Date check) {
        return base.compareTo(check) < 0;
    }

    public static Long difference(Date older, Date newer) {
        if (older.compareTo(newer) < 0) {
            return newer.getTime() - older.getTime();
        }
        return null;
    }

    public static Double differenceDays(Date older, Date newer) {
        Long msecs = DateUtils.difference(older, newer);
        if (msecs == null) {
            return null;
        }
        return (double)msecs.longValue() / 1000.0 / 60.0 / 60.0 / 24.0;
    }

    public static Double differenceHours(Date older, Date newer) {
        Long msecs = DateUtils.difference(older, newer);
        if (msecs == null) {
            return null;
        }
        return (double)msecs.longValue() / 1000.0 / 60.0 / 60.0;
    }

    public static Double differenceMinutes(Date older, Date newer) {
        Long msecs = DateUtils.difference(older, newer);
        if (msecs == null) {
            return null;
        }
        return (double)msecs.longValue() / 1000.0 / 60.0;
    }

    public static Double differenceSeconds(Date older, Date newer) {
        Long msecs = DateUtils.difference(older, newer);
        if (msecs == null) {
            return null;
        }
        return (double)msecs.longValue() / 1000.0;
    }

    public static String msecToString(Long msec) {
        StringBuilder result = new StringBuilder();
        if (msec == null) {
            result.append("invalid");
        } else {
            long value = msec;
            long position = value / 3600000L;
            if (position < 10L) {
                result.append("0");
            }
            result.append(position);
            position = (value %= 3600000L) / 60000L;
            result.append(":");
            if (position < 10L) {
                result.append("0");
            }
            result.append(position);
            position = (value %= 60000L) / 1000L;
            result.append(":");
            if (position < 10L) {
                result.append("0");
            }
            result.append(position);
            position = value % 1000L;
            result.append(".");
            if (position < 10L) {
                result.append("0");
            }
            if (position < 100L) {
                result.append("0");
            }
            result.append(position);
        }
        return result.toString();
    }

    public static Date parseString(String s, String format) {
        return DateUtils.parseString(s, new DateFormatString(format));
    }

    public static Date parseString(String s, DateFormatString format) {
        return format.toDateFormat().parse(s);
    }

    public static DateTime now() {
        return new DateTime();
    }

    public static Time nowTime() {
        GregorianCalendar cal = new GregorianCalendar(DateUtils.getLocale());
        cal.setTime(new Date());
        cal.set(1, 0);
        cal.set(2, 0);
        cal.set(5, 1);
        return new Time(cal.getTime());
    }

    public static Date today() {
        GregorianCalendar cal = new GregorianCalendar(DateUtils.getLocale());
        cal.setTime(new Date());
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }
}

