/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class NamedCounter
implements Serializable {
    private static final long serialVersionUID = -690032882282626773L;
    protected Hashtable<String, Integer> m_Counts = new Hashtable();

    public synchronized void clear() {
        this.m_Counts.clear();
    }

    public synchronized void clear(String name) {
        this.m_Counts.put(name, 0);
    }

    public synchronized int current(String name) {
        if (!this.m_Counts.containsKey(name)) {
            this.m_Counts.put(name, 0);
        }
        return this.m_Counts.get(name);
    }

    public synchronized int next(String name) {
        this.m_Counts.put(name, this.current(name) + 1);
        return this.m_Counts.get(name);
    }

    public synchronized boolean hasReached(String name, int limit) {
        return this.current(name) >= limit;
    }

    public synchronized boolean has(String name) {
        return this.m_Counts.containsKey(name);
    }

    public synchronized Iterator<String> names() {
        return this.m_Counts.keySet().iterator();
    }

    public synchronized Iterator<String> names(boolean asc) {
        ArrayList<String> result = new ArrayList<String>(this.m_Counts.keySet());
        CounterComparator comp = new CounterComparator(this);
        Collections.sort(result, comp);
        if (!asc) {
            Collections.reverse(result);
        }
        return result.iterator();
    }

    public synchronized Set<String> nameSet() {
        return this.m_Counts.keySet();
    }

    public synchronized String toString() {
        return this.m_Counts.toString();
    }

    public static class CounterComparator
    implements Comparator<String> {
        protected NamedCounter m_Counter;

        public CounterComparator(NamedCounter counter) {
            if (counter == null) {
                throw new IllegalArgumentException("No named counter provided to obtain associated counts from!");
            }
            this.m_Counter = counter;
        }

        @Override
        public int compare(String o1, String o2) {
            if (this.m_Counter == null) {
                return 0;
            }
            if (!this.m_Counter.has(o1)) {
                return 1;
            }
            if (!this.m_Counter.has(o2)) {
                return -1;
            }
            return new Integer(this.m_Counter.current(o1)).compareTo(this.m_Counter.current(o2));
        }
    }
}

