/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.BaseText;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BaseAnnotation
extends BaseText {
    private static final long serialVersionUID = -8038455603270458019L;
    public static final String TAG_START = "!{";
    public static final String TAG_END = "}";
    protected List<Tag> m_Tags;
    protected List m_Parts;

    public BaseAnnotation() {
    }

    public BaseAnnotation(String s) {
        super(s);
    }

    @Override
    protected String convert(String value) {
        this.m_Tags = null;
        this.m_Parts = null;
        return super.convert(value);
    }

    public boolean hasTag() {
        return this.getValue().indexOf(TAG_START) > -1;
    }

    protected void parse() {
        int start;
        if (this.m_Tags != null) {
            return;
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        ArrayList<Object> parts = new ArrayList<Object>();
        String s = this.getValue();
        while (s.length() > 0 && (start = s.indexOf(TAG_START)) > -1) {
            if (start > 0) {
                parts.add(s.substring(0, start));
            }
            if ((s = s.substring(start)).indexOf(TAG_END) > -1) {
                String tagStr = s.substring(0, s.indexOf(TAG_END) + TAG_END.length());
                s = s.substring(s.indexOf(TAG_END) + TAG_END.length());
                Tag tag = Tag.parse(tagStr);
                if (tag == null) continue;
                tags.add(tag);
                parts.add(tag);
                continue;
            }
            if (s.length() > 0) {
                parts.add(s);
            }
            s = "";
        }
        if (s.length() > 0) {
            parts.add(s);
        }
        this.m_Tags = tags;
        this.m_Parts = parts;
    }

    public synchronized List<Tag> getTags() {
        this.parse();
        return this.m_Tags;
    }

    public synchronized List getParts() {
        this.parse();
        return this.m_Parts;
    }

    @Override
    public String getTipText() {
        return "An arbitrary annotation string, supports tags of format '!{tagname[:comma-separated list of key=value pairs]}'.";
    }

    public static class Tag
    implements Serializable,
    Comparable<Tag> {
        private static final long serialVersionUID = 874856743336401021L;
        protected String m_Name;
        protected HashMap<String, String> m_Options;

        public Tag(String name) {
            this(name, null);
        }

        public Tag(String name, HashMap<String, String> options) {
            this.m_Name = name;
            this.m_Options = options == null ? new HashMap() : (HashMap)options.clone();
        }

        public String getName() {
            return this.m_Name;
        }

        public HashMap<String, String> getOptions() {
            return this.m_Options;
        }

        @Override
        public int compareTo(Tag o) {
            if (o == null) {
                throw new NullPointerException();
            }
            int result = this.m_Name.compareTo(o.getName());
            if (result == 0) {
                result = new Integer(this.m_Options.size()).compareTo(o.getOptions().size());
            }
            if (result == 0) {
                for (String key : this.m_Options.keySet()) {
                    if (!o.getOptions().containsKey(key)) {
                        result = 1;
                        break;
                    }
                    result = this.m_Options.get(key).compareTo(o.getOptions().get(key));
                    if (result == 0) continue;
                    break;
                }
                for (String key : o.getOptions().keySet()) {
                    if (!this.m_Options.containsKey(key)) {
                        result = -1;
                        break;
                    }
                    result = this.m_Options.get(key).compareTo(o.getOptions().get(key));
                    if (result == 0) continue;
                    break;
                }
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Tag) {
                return this.compareTo((Tag)obj) == 0;
            }
            return false;
        }

        public String toString() {
            return "name=" + this.m_Name + ", options=" + this.m_Options;
        }

        public static Tag parse(String s) {
            Tag result = null;
            if (s.indexOf(BaseAnnotation.TAG_START) == -1) {
                return result;
            }
            if (s.indexOf(BaseAnnotation.TAG_END) < s.indexOf(BaseAnnotation.TAG_START)) {
                return result;
            }
            s = s.substring(s.indexOf(BaseAnnotation.TAG_START) + BaseAnnotation.TAG_START.length());
            if ((s = s.substring(0, s.indexOf(BaseAnnotation.TAG_END))).indexOf(":") > -1) {
                String[] parts = s.split(":");
                String name = parts[0];
                String[] options = parts[1].split(",");
                HashMap<String, String> map = new HashMap<String, String>();
                for (String option : options) {
                    parts = option.trim().split("=");
                    if (parts.length != 2) continue;
                    map.put(parts[0], parts[1]);
                }
                result = new Tag(name, map);
            } else {
                String name = s;
                result = new Tag(name);
            }
            return result;
        }
    }
}

