/*
 * Decompiled with CFR 0.152.
 */
package adams.data;

import adams.core.CloneHandler;
import adams.core.Mergeable;
import adams.core.option.OptionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Notes
implements Serializable,
CloneHandler<Notes>,
Mergeable<Notes> {
    private static final long serialVersionUID = -6179090129357843542L;
    public static final String WARNING = "WARNING: ";
    public static final String ERROR = "ERROR: ";
    public static final String PROCESS_INFORMATION = "PROCESS INFORMATION";
    protected HashMap<String, List<String>> m_Notes = new HashMap();

    public void clear() {
        this.m_Notes.clear();
    }

    public void addNote(Class cls, String note) {
        this.addNote(cls.getName(), note);
    }

    public void addNote(String classname, String note) {
        List<String> notes = this.m_Notes.get(classname);
        if (notes == null) {
            notes = new ArrayList<String>();
            this.m_Notes.put(classname, notes);
        }
        if (!notes.contains(note)) {
            notes.add(new String(note));
        }
    }

    public void addWarning(Class cls, String note) {
        this.addNote(cls.getName(), WARNING + note);
    }

    public void addWarning(String classname, String note) {
        this.addNote(classname, WARNING + note);
    }

    public void addError(Class cls, String note) {
        this.addNote(cls.getName(), ERROR + note);
    }

    public void addError(String classname, String note) {
        this.addNote(classname, ERROR + note);
    }

    public void addProcessInformation(Object obj) {
        this.addNote(PROCESS_INFORMATION, OptionUtils.getCommandLine(obj));
    }

    public boolean hasNotes(Class cls) {
        return this.hasNotes(cls.getName());
    }

    public boolean hasNotes(String classname) {
        return this.m_Notes.get(classname) != null;
    }

    public boolean hasWarning() {
        return this.getWarnings().size() > 0;
    }

    public boolean hasError() {
        return this.getErrors().size() > 0;
    }

    public boolean hasProcessInformation() {
        return this.hasNotes(PROCESS_INFORMATION);
    }

    public boolean hasOthers() {
        return this.getOthers().size() > 0;
    }

    public List<String> getNotes(Class cls) {
        return this.getNotes(cls.getName());
    }

    public List<String> getNotes(String classname) {
        return this.m_Notes.get(classname);
    }

    public Notes getSubset(String regex) {
        Notes result = new Notes();
        Iterator<String> iter = this.notes();
        block0: while (iter.hasNext()) {
            String key = iter.next();
            List<String> list = this.getNotes(key);
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).matches(regex)) continue;
                result.addNote(key, list.get(i));
                continue block0;
            }
        }
        return result;
    }

    public Notes getWarnings() {
        return this.getSubset("^WARNING: .*");
    }

    public Notes getErrors() {
        return this.getSubset("^ERROR: .*");
    }

    public Notes getPrefixSubset(String prefix) {
        Notes result = new Notes();
        List<String> items = this.getNotes(prefix);
        if (items != null) {
            ArrayList<String> itemsNew = new ArrayList<String>(items);
            result.m_Notes.put(prefix, itemsNew);
        }
        return result;
    }

    public Notes getProcessInformation() {
        return this.getPrefixSubset(PROCESS_INFORMATION);
    }

    public Notes getOthers() {
        Notes excluded = new Notes();
        excluded.mergeWith(this.getWarnings());
        excluded.mergeWith(this.getErrors());
        excluded.mergeWith(this.getProcessInformation());
        Notes result = this.minus(excluded);
        return result;
    }

    public void removeNotes(Class cls) {
        this.removeNotes(cls.getName());
    }

    public void removeNotes(String classname) {
        this.m_Notes.remove(classname);
    }

    public Iterator<String> notes() {
        return this.m_Notes.keySet().iterator();
    }

    @Override
    public Notes getClone() {
        Notes result = new Notes();
        for (String classname : this.m_Notes.keySet()) {
            List<String> list = this.m_Notes.get(classname);
            for (int i = 0; i < list.size(); ++i) {
                result.addNote(classname, list.get(i));
            }
        }
        return result;
    }

    @Override
    public void mergeWith(Notes other) {
        this.m_Notes = this.union((Notes)other).m_Notes;
    }

    public Notes union(Notes other) {
        Notes result = this.getClone();
        Iterator<String> iter = other.notes();
        while (iter.hasNext()) {
            int i;
            String classname = iter.next();
            List<String> list = other.getNotes(classname);
            if (result.hasNotes(classname)) {
                for (i = 0; i < list.size(); ++i) {
                    if (result.m_Notes.get(classname).contains(list.get(i))) continue;
                    result.addNote(classname, list.get(i));
                }
                continue;
            }
            for (i = 0; i < list.size(); ++i) {
                result.addNote(classname, list.get(i));
            }
        }
        return result;
    }

    public Notes minus(Notes exclude) {
        Notes result = new Notes();
        Iterator<String> keys = this.notes();
        while (keys.hasNext()) {
            int i;
            List<String> items;
            String key = keys.next();
            if (!exclude.hasNotes(key)) {
                items = this.getNotes(key);
                for (i = 0; i < items.size(); ++i) {
                    result.addNote(key, items.get(i));
                }
                continue;
            }
            ArrayList<String> itemsNew = new ArrayList<String>(this.getNotes(key));
            items = exclude.getNotes(key);
            i = 0;
            while (i < itemsNew.size()) {
                if (items.contains(itemsNew.get(i))) {
                    itemsNew.remove(i);
                    continue;
                }
                ++i;
            }
            if (itemsNew.size() <= 0) continue;
            for (i = 0; i < itemsNew.size(); ++i) {
                result.addNote(key, (String)itemsNew.get(i));
            }
        }
        return result;
    }

    public int size() {
        return this.m_Notes.size();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Notes)) {
            return false;
        }
        Notes notes = (Notes)o;
        return this.m_Notes.equals(notes.m_Notes);
    }

    public int hashCode() {
        return this.m_Notes.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        Iterator<String> iter = this.notes();
        while (iter.hasNext()) {
            String key = iter.next();
            List<String> list = this.getNotes(key);
            result.append(key + ":\n");
            for (int i = 0; i < list.size(); ++i) {
                result.append("  " + (i + 1) + ". " + list.get(i) + "\n");
            }
        }
        return result.toString();
    }

    public static void main(String[] args) {
        Notes n1 = new Notes();
        n1.addNote(String.class, "blah");
        n1.addNote(String.class, "bloerk");
        n1.addNote(Object.class, "oblah");
        n1.addNote(Object.class, "obble");
        Notes n2 = n1.getClone();
        Notes n3 = n1.getClone();
        n3.mergeWith(n2);
        Notes n4 = n1.getClone();
        n4.removeNotes(Object.class);
        Notes n5 = n1.getClone();
        n5.addError(String.class, "nooooo!");
        System.out.println("n1 =?= n2: " + n1.equals(n2));
        System.out.println("n1 =?= n3: " + n1.equals(n3));
        System.out.println("n1 =?= n4: " + n1.equals(n4));
        System.out.println();
        System.out.println("error in n1: " + n1.hasError());
        System.out.println("error in n2: " + n2.hasError());
        System.out.println("error in n3: " + n3.hasError());
        System.out.println("error in n4: " + n4.hasError());
        System.out.println("error in n5: " + n5.hasError());
        System.out.println();
        System.out.println("warning in n1: " + n1.hasWarning());
        System.out.println("warning in n2: " + n1.hasWarning());
        System.out.println("warning in n3: " + n1.hasWarning());
        System.out.println("warning in n4: " + n1.hasWarning());
        System.out.println("warning in n5: " + n1.hasWarning());
        System.out.println();
        Notes merged = n1.getClone();
        merged.mergeWith(n5);
        System.out.println("merged =?= n5: " + merged.equals(n5));
        Notes union = n1.union(n5);
        System.out.println("union =?= n5: " + union.equals(n5));
        Notes minus = merged.minus(n1);
        System.out.println("merged - n1:\n" + minus);
    }
}

