/*
 * Decompiled with CFR 0.152.
 */
package adams.data.featureconverter;

import adams.core.CloneHandler;
import adams.data.report.DataType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class HeaderDefinition
implements Serializable,
Comparable<HeaderDefinition>,
CloneHandler<HeaderDefinition> {
    private static final long serialVersionUID = 3616920834737849123L;
    public static final String DEFAULT_DATASET_NAME = "Dataset";
    protected String m_Dataset;
    protected List<String> m_Names;
    protected List<DataType> m_Types;
    protected Integer m_HashCode;

    public HeaderDefinition() {
        this(null);
    }

    public HeaderDefinition(String dataset) {
        this(dataset, new ArrayList<String>(), new ArrayList<DataType>());
    }

    public HeaderDefinition(String dataset, List<String> names, List<DataType> types) {
        if (dataset == null) {
            dataset = DEFAULT_DATASET_NAME;
        }
        if (names.size() != types.size()) {
            throw new IllegalArgumentException("Number of names and types vary: " + names.size() + " != " + types.size());
        }
        this.m_Dataset = dataset;
        this.m_Names = new ArrayList<String>(names);
        this.m_Types = new ArrayList<DataType>(types);
    }

    @Override
    public HeaderDefinition getClone() {
        return new HeaderDefinition(this.m_Dataset, this.m_Names, this.m_Types);
    }

    public void setDataset(String value) {
        if (value == null) {
            value = DEFAULT_DATASET_NAME;
        }
        this.m_Dataset = value;
    }

    public String getDataset() {
        return this.m_Dataset;
    }

    public List<String> getNames() {
        return this.m_Names;
    }

    public List<DataType> getTypes() {
        return this.m_Types;
    }

    public int size() {
        return this.m_Names.size();
    }

    public String getName(int index) {
        return this.m_Names.get(index);
    }

    public DataType getType(int index) {
        return this.m_Types.get(index);
    }

    public void rename(int index, String name) {
        this.m_Names.set(index, name);
    }

    public void add(int index, String name, DataType type) {
        this.m_Names.add(index, name);
        this.m_Types.add(index, type);
    }

    public void add(String name, DataType type) {
        this.m_Names.add(name);
        this.m_Types.add(type);
    }

    public void add(HeaderDefinition definition) {
        this.m_Names.addAll(definition.getNames());
        this.m_Types.addAll(definition.getTypes());
    }

    public void remove(int index) {
        this.m_Names.remove(index);
        this.m_Types.remove(index);
    }

    public synchronized int hashCode() {
        if (this.m_HashCode == null) {
            this.m_HashCode = this.toString().hashCode();
        }
        return this.m_HashCode;
    }

    @Override
    public int compareTo(HeaderDefinition o) {
        int i;
        int result = this.m_Dataset.compareTo(o.getDataset());
        if (result == 0) {
            result = new Integer(this.m_Names.size()).compareTo(o.m_Names.size());
        }
        if (result == 0) {
            for (i = 0; i < this.m_Names.size() && (result = this.m_Names.get(i).compareTo(o.m_Names.get(i))) == 0; ++i) {
            }
        }
        if (result == 0) {
            for (i = 0; i < this.m_Types.size() && (result = this.m_Types.get(i).compareTo((Enum)o.m_Types.get(i))) == 0; ++i) {
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HeaderDefinition) {
            return this.compareTo((HeaderDefinition)obj) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.m_Dataset + "|");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(this.getName(i) + ":" + this.getType(i));
        }
        return result.toString();
    }
}

