/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import java.util.List;

public class DownSample<T extends DataContainer>
extends AbstractFilter<T> {
    private static final long serialVersionUID = -7633117391523711914L;
    protected int m_NthPoint;

    @Override
    public String globalInfo() {
        return "A filter that returns only every n-th data point.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("nth", "nthPoint", 1);
    }

    public void setNthPoint(int value) {
        this.m_NthPoint = value;
        this.reset();
    }

    public int getNthPoint() {
        return this.m_NthPoint;
    }

    public String nthPointTipText() {
        return "Only every n-th point will be output.";
    }

    @Override
    protected T processData(T data) {
        DataContainer result = data.getHeader();
        List points = data.toList();
        for (int i = 0; i < points.size(); ++i) {
            if ((i + 1) % this.m_NthPoint != 0) continue;
            result.add((DataPoint)((DataPoint)points.get(i)).getClone());
        }
        return (T)result;
    }
}

