/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image;

import adams.core.CleanUpHandler;
import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionUtils;
import adams.data.container.AbstractSimpleContainer;
import adams.data.image.AbstractImageContainer;

public abstract class AbstractImageTransformer<T extends AbstractImageContainer>
extends AbstractOptionHandler
implements Comparable,
CleanUpHandler,
QuickInfoSupporter {
    private static final long serialVersionUID = 4566948525813804085L;

    @Override
    public String getQuickInfo() {
        return null;
    }

    protected void checkImage(T img) {
        if (img == null) {
            throw new IllegalStateException("No image provided!");
        }
    }

    protected abstract T[] doTransform(T var1);

    public T[] transform(T img) {
        this.checkImage(img);
        AbstractImageContainer[] result = this.doTransform((AbstractImageContainer)((AbstractSimpleContainer)img).getClone());
        for (int i = 0; i < result.length; ++i) {
            result[i].getNotes().addProcessInformation(this);
        }
        return result;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public T shallowCopy() {
        return this.shallowCopy(false);
    }

    public T shallowCopy(boolean expand) {
        return (T)((AbstractImageContainer)((Object)OptionUtils.shallowCopy(this, expand)));
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void destroy() {
        this.cleanUp();
        super.destroy();
    }
}

