/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.ClassLister;
import adams.core.io.FileFormatHandler;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionHandler;
import adams.data.container.AbstractSimpleContainer;
import adams.data.image.AbstractImageContainer;
import adams.data.io.output.AbstractImageWriter;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;

public abstract class AbstractImageReader<T extends AbstractImageContainer>
extends AbstractOptionHandler
implements FileFormatHandler {
    private static final long serialVersionUID = 2069846153567151035L;

    @Override
    public abstract String getFormatDescription();

    @Override
    public abstract String[] getFormatExtensions();

    @Override
    public String getDefaultFormatExtension() {
        return this.getFormatExtensions()[0];
    }

    public abstract AbstractImageWriter getCorrespondingWriter();

    public boolean isAvailable() {
        return true;
    }

    protected void check(PlaceholderFile file) {
        if (file == null) {
            throw new IllegalStateException("No file provided!");
        }
        if (!file.exists()) {
            throw new IllegalStateException("File '" + file + "' does not exist!");
        }
        if (file.isDirectory()) {
            throw new IllegalStateException("File '" + file + "' points to a directory!");
        }
    }

    protected abstract T doRead(PlaceholderFile var1);

    protected T postProcess(T cont, PlaceholderFile file) {
        if (((AbstractSimpleContainer)cont).hasReport()) {
            Report report = ((AbstractSimpleContainer)cont).getReport();
            report.addField(new Field("Filename", DataType.STRING));
            report.setStringValue("Filename", file.getAbsolutePath());
        }
        return cont;
    }

    public T read(PlaceholderFile file) {
        this.check(file);
        T result = this.doRead(file);
        if (result != null) {
            result = this.postProcess(result, file);
        }
        return result;
    }

    public static String[] getReaders() {
        return ClassLister.getSingleton().getClassnames(AbstractImageReader.class);
    }
}

