/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.ShallowCopySupporter;
import adams.core.io.FileFormatHandler;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.data.container.DataContainer;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDataContainerWriter<T extends DataContainer>
extends AbstractOptionHandler
implements Comparable,
CleanUpHandler,
ShallowCopySupporter<AbstractDataContainerWriter>,
FileFormatHandler {
    private static final long serialVersionUID = 7097110023547675936L;
    protected PlaceholderFile m_Output;
    protected boolean m_OutputIsFile;

    @Override
    public abstract String getFormatDescription();

    @Override
    public abstract String[] getFormatExtensions();

    @Override
    public String getDefaultFormatExtension() {
        return this.getFormatExtensions()[0];
    }

    @Override
    protected void reset() {
        super.reset();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output", "output", new PlaceholderFile(System.getProperty("java.io.tmpdir") + PlaceholderFile.separator + "out.tmp"));
    }

    public boolean isOutputFile() {
        return this.m_OutputIsFile;
    }

    public void setOutput(PlaceholderFile value) {
        this.m_Output = value == null ? new PlaceholderFile(".") : value;
    }

    public PlaceholderFile getOutput() {
        return this.m_Output;
    }

    public String outputTipText() {
        if (this.m_OutputIsFile) {
            return "The file to write the container to.";
        }
        return "The directory to write the container to.";
    }

    public abstract boolean canWriteMultiple();

    public boolean write(T data) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(data);
        return this.write((List<T>)list);
    }

    public boolean write(List<T> data) {
        this.checkData(data);
        return this.writeData(data);
    }

    protected void checkData(List<T> data) {
        if (!this.canWriteMultiple() && data.size() > 1) {
            throw new IllegalStateException(this.getClass().getName() + " does not support writing of multiple containers!");
        }
        if (this.m_OutputIsFile) {
            if (this.m_Output.isDirectory()) {
                throw new IllegalStateException("No output file but directory provided ('" + this.m_Output + "')!");
            }
            if (!this.m_Output.getParentFile().exists()) {
                throw new IllegalStateException("Output file's directory '" + this.m_Output.getParentFile() + "' does not exist!");
            }
        } else {
            if (!this.m_Output.isDirectory()) {
                throw new IllegalStateException("Output is not a  directory ('" + this.m_Output + "')!");
            }
            if (!this.m_Output.exists()) {
                throw new IllegalStateException("Output directory '" + this.m_Output + "' does not exist!");
            }
        }
    }

    protected abstract boolean writeData(List<T> var1);

    @Override
    public void cleanUp() {
        this.reset();
    }

    @Override
    public void destroy() {
        this.cleanUp();
        super.destroy();
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public AbstractDataContainerWriter shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractDataContainerWriter shallowCopy(boolean expand) {
        return (AbstractDataContainerWriter)OptionUtils.shallowCopy(this, expand);
    }

    public static String[] getWriters() {
        return ClassLister.getSingleton().getClassnames(AbstractDataContainerWriter.class);
    }

    public static AbstractDataContainerWriter forName(String classname, String[] options) {
        AbstractDataContainerWriter result;
        try {
            result = (AbstractDataContainerWriter)OptionUtils.forName(AbstractDataContainerWriter.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractDataContainerWriter forCommandLine(String cmdline) {
        return (AbstractDataContainerWriter)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }
}

