/*
 * Decompiled with CFR 0.152.
 */
package adams.data.padding;

import adams.data.padding.PaddingType;

public class PaddingHelper {
    public static int nextPowerOf2(int n) {
        int exp = (int)StrictMath.ceil(StrictMath.log(n) / StrictMath.log(2.0));
        exp = StrictMath.max(2, exp);
        return (int)StrictMath.pow(2.0, exp);
    }

    public static float[] padPow2(float[] data, PaddingType type) {
        return PaddingHelper.pad(data, PaddingHelper.nextPowerOf2(data.length), type);
    }

    public static float[] pad(float[] data, int numPoints, PaddingType type) {
        if (numPoints < data.length) {
            throw new IllegalArgumentException("Number of output data points is smaller than input data points: " + numPoints + " < " + data.length);
        }
        float[] result = new float[numPoints];
        System.arraycopy(data, 0, result, 0, data.length);
        switch (type) {
            case ZERO: {
                for (int i = data.length; i < numPoints; ++i) {
                    result[i] = 0.0f;
                }
                break;
            }
            case LAST: {
                for (int i = data.length; i < numPoints; ++i) {
                    result[i] = result[data.length - 1];
                }
                break;
            }
            default: {
                throw new IllegalStateException("Padding " + type + " not implemented!");
            }
        }
        return result;
    }

    public static double[] padPow2(double[] data, PaddingType type) {
        return PaddingHelper.pad(data, PaddingHelper.nextPowerOf2(data.length), type);
    }

    public static double[] pad(double[] data, int numPoints, PaddingType type) {
        if (numPoints < data.length) {
            throw new IllegalArgumentException("Number of output data points is smaller than input data points: " + numPoints + " < " + data.length);
        }
        double[] result = new double[numPoints];
        System.arraycopy(data, 0, result, 0, data.length);
        switch (type) {
            case ZERO: {
                for (int i = data.length; i < numPoints; ++i) {
                    result[i] = 0.0;
                }
                break;
            }
            case LAST: {
                for (int i = data.length; i < numPoints; ++i) {
                    result[i] = result[data.length - 1];
                }
                break;
            }
            default: {
                throw new IllegalStateException("Padding " + type + " not implemented!");
            }
        }
        return result;
    }
}

