/*
 * Decompiled with CFR 0.152.
 */
package adams.data.smoothing;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.container.DataContainer;
import adams.data.filter.AbstractLOWESS;
import adams.data.smoothing.AbstractSmoother;

public abstract class AbstractLOWESSBased<T extends DataContainer>
extends AbstractSmoother<T>
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -4052647569528377770L;
    protected AbstractLOWESS m_LOWESS;

    @Override
    public String globalInfo() {
        return "A LOWESS based smoothing algorithm.\nFor more information on LOWESS see:\n\n" + this.getTechnicalInformation().toString();
    }

    protected abstract AbstractLOWESS getDefault();

    @Override
    public TechnicalInformation getTechnicalInformation() {
        return this.getDefault().getTechnicalInformation();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_LOWESS = this.getDefault();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("window-size", "windowSize", 20, 1, null);
    }

    public void setWindowSize(int value) {
        this.m_LOWESS.setWindowSize(value);
    }

    public int getWindowSize() {
        return this.m_LOWESS.getWindowSize();
    }

    public String windowSizeTipText() {
        return this.m_LOWESS.windowSizeTipText();
    }

    @Override
    protected T processData(T data) {
        T result = this.m_LOWESS.filter(data);
        this.m_LOWESS.cleanUp();
        return result;
    }
}

