/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.CloneHandler;
import adams.core.DateFormat;
import adams.core.Properties;
import adams.core.Utils;
import adams.core.net.InternetHelper;
import adams.data.id.DatabaseIDHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class LogEntry
implements Serializable,
DatabaseIDHandler,
CloneHandler<LogEntry>,
Comparable<LogEntry> {
    private static final long serialVersionUID = 565425043739971996L;
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String FILENAME = "LogEntry.props";
    public static final String KEY_DBID = "DB-ID";
    public static final String KEY_ID = "ID";
    public static final String KEY_HOST = "Host";
    public static final String KEY_IP = "IP";
    public static final String KEY_ERRORS = "Errors";
    public static final String STATUS_NEW = "New";
    public static final String STATUS_OPEN = "Open";
    public static final String STATUS_RESOLVED = "Resolved";
    protected int m_DatabaseID = -1;
    protected String m_Host = InternetHelper.getLocalHostName();
    protected String m_IP = InternetHelper.getLocalHostIP();
    protected String m_Type = "";
    protected String m_Message = "";
    protected Date m_Generation = new Date();
    protected String m_Source = "";
    protected String m_Status = "";
    protected static DateFormat m_DateFormat = new DateFormat("yyyy-MM-dd HH:mm:ss");

    public void setDatabaseID(int value) {
        this.m_DatabaseID = value;
    }

    @Override
    public int getDatabaseID() {
        return this.m_DatabaseID;
    }

    public void setHost(String value) {
        this.m_Host = value;
    }

    public String getHost() {
        return this.m_Host;
    }

    public void setIP(String value) {
        this.m_IP = value;
    }

    public String getIP() {
        return this.m_IP;
    }

    public void setType(String value) {
        this.m_Type = value == null ? "" : value;
    }

    public String getType() {
        return this.m_Type;
    }

    public void setMessage(String value) {
        this.m_Message = value == null ? "" : value.replaceAll("\"", "'");
    }

    public void setMessage(Properties value) {
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(value.toString().split("\n")));
        Utils.removeComments(lines, "#");
        this.m_Message = Utils.flatten(lines, "\n");
    }

    public String getMessage() {
        return this.m_Message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getMessageAsProperties() {
        Properties result = new Properties();
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(new ByteArrayInputStream(this.m_Message.getBytes()));
            result.load(stream);
        }
        catch (Exception e) {
            System.err.println("Failed to turn message into properties:");
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public void setGeneration(Date value) {
        this.m_Generation = value == null ? new Date() : value;
    }

    public Date getGeneration() {
        return this.m_Generation;
    }

    public String getGenerationAsString() {
        return m_DateFormat.format(this.m_Generation);
    }

    public void setSource(String value) {
        this.m_Source = value == null ? "" : value;
    }

    public String getSource() {
        return this.m_Source;
    }

    public void setStatus(String value) {
        this.m_Status = value == null ? "" : value;
    }

    public String getStatus() {
        return this.m_Status;
    }

    @Override
    public LogEntry getClone() {
        LogEntry result = new LogEntry();
        result.setDatabaseID(this.m_DatabaseID);
        result.setHost(new String(this.getHost()));
        result.setIP(new String(this.getIP()));
        result.setType(new String(this.m_Type));
        result.setMessage(new String(this.m_Message));
        result.setGeneration((Date)this.m_Generation.clone());
        result.setSource(new String(this.m_Source));
        result.setStatus(new String(this.m_Status));
        return result;
    }

    @Override
    public int compareTo(LogEntry o) {
        int result = new Integer(this.getDatabaseID()).compareTo(new Integer(o.getDatabaseID()));
        if (result == 0) {
            result = this.getGeneration().compareTo(o.getGeneration());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LogEntry)) {
            return false;
        }
        return this.compareTo((LogEntry)obj) == 0;
    }

    public int hashCode() {
        return new String(this.m_DatabaseID + " " + this.m_Generation).hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Host: " + this.m_Host + "\n");
        result.append("IP: " + this.m_IP + "\n");
        result.append("Type: " + this.m_Type + "\n");
        result.append("Generation: " + this.getGenerationAsString() + "\n");
        result.append("Source: " + this.m_Source + "\n");
        result.append("Status: " + this.m_Status + "\n");
        result.append("Message:\n" + this.m_Message);
        result.append("\n");
        return result.toString();
    }
}

