/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.docbook;

import adams.doc.xml.AbstractComplexTag;
import adams.doc.xml.AbstractTag;
import adams.doc.xml.DefaultComplexTag;
import adams.doc.xml.DefaultSimpleTag;

public class InformalTable
extends AbstractComplexTag {
    private static final long serialVersionUID = -1301634257381722080L;
    protected AbstractComplexTag m_Head;
    protected AbstractComplexTag m_Body;
    protected int m_NumCols;

    public InformalTable(int numCols) {
        super("informaltable");
        this.m_NumCols = numCols;
        DefaultComplexTag tgroup = new DefaultComplexTag("tgroup");
        tgroup.setAttribute("cols", "" + numCols);
        this.add(tgroup);
        this.m_Head = null;
        this.m_Body = new DefaultComplexTag("tbody");
        tgroup.add(this.m_Body);
    }

    public InformalTable(String[] cells) {
        super("informaltable");
        this.m_NumCols = cells.length;
        DefaultComplexTag tgroup = new DefaultComplexTag("tgroup");
        tgroup.setAttribute("cols", "" + cells.length);
        this.add(tgroup);
        this.m_Head = new DefaultComplexTag("thead");
        tgroup.add(this.m_Head);
        this.m_Body = new DefaultComplexTag("tbody");
        tgroup.add(this.m_Body);
        this.addRow(this.m_Head, cells);
    }

    public InformalTable(AbstractTag[] cells) {
        super("informaltable");
        this.m_NumCols = cells.length;
        DefaultComplexTag tgroup = new DefaultComplexTag("tgroup");
        tgroup.setAttribute("cols", "" + cells.length);
        this.add(tgroup);
        this.m_Head = new DefaultComplexTag("thead");
        tgroup.add(this.m_Head);
        this.m_Body = new DefaultComplexTag("tbody");
        tgroup.add(this.m_Body);
        this.addRow(this.m_Head, cells);
    }

    public int getNumCols() {
        return this.m_NumCols;
    }

    public boolean hasHead() {
        return this.m_Head != null;
    }

    public AbstractComplexTag getHead() {
        return this.m_Head;
    }

    public AbstractComplexTag getBody() {
        return this.m_Body;
    }

    protected AbstractComplexTag addRow(AbstractComplexTag parent, String[] cells) {
        if (cells.length != this.m_NumCols) {
            throw new IllegalArgumentException("Number of columns differ (expected/actual): " + this.m_NumCols + " != " + cells.length);
        }
        DefaultComplexTag result = new DefaultComplexTag("row");
        parent.add(result);
        for (String cell : cells) {
            DefaultSimpleTag entry = new DefaultSimpleTag("entry", cell);
            result.add(entry);
        }
        return result;
    }

    public AbstractComplexTag addRow(String[] cells) {
        return this.addRow(this.getBody(), cells);
    }

    protected AbstractComplexTag addRow(AbstractComplexTag parent, AbstractTag[] cells) {
        if (cells.length != this.m_NumCols) {
            throw new IllegalArgumentException("Number of columns differ (expected/actual): " + this.m_NumCols + " != " + cells.length);
        }
        DefaultComplexTag result = new DefaultComplexTag("row");
        parent.add(result);
        for (AbstractTag cell : cells) {
            DefaultComplexTag entry = new DefaultComplexTag("entry");
            entry.add(cell);
            result.add(entry);
        }
        return result;
    }

    public AbstractComplexTag addRow(AbstractTag[] cells) {
        return this.addRow(this.getBody(), cells);
    }
}

