/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.io.PlaceholderFile;
import adams.core.management.ProcessUtils;
import adams.flow.control.Tee;
import adams.flow.core.Token;
import java.io.File;

public class JMap
extends Tee {
    private static final long serialVersionUID = -4497496140953116320L;
    protected PlaceholderFile m_Executable;
    protected String m_AdditionalOptions;
    protected long m_PID;
    protected long m_ActualPID;

    @Override
    public String globalInfo() {
        return "Runs jmap whenever a token gets passed through. The generated output gets tee-ed off.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("executable", "executable", new PlaceholderFile(this.getJMapExecutablePath()), false);
        this.m_OptionManager.add("additional", "additionalOptions", "-histo:live");
        this.m_OptionManager.add("pid", "PID", -999L);
    }

    protected String getJMapExecutable() {
        String os = System.getProperty("os.name").toLowerCase();
        String result = os.indexOf("windows") > -1 ? "jmap.exe" : "jmap";
        return result;
    }

    protected String getJMapExecutablePath() {
        File jvmPath = new File(System.getProperty("java.home"));
        if (jvmPath.getAbsolutePath().endsWith(File.separator + "jre")) {
            jvmPath = jvmPath.getParentFile();
        }
        String result = (jvmPath = new File(jvmPath.getAbsolutePath() + File.separator + "bin")).exists() ? jvmPath.getAbsolutePath() + File.separator + this.getJMapExecutable() : this.getJMapExecutable();
        return result;
    }

    public void setExecutable(PlaceholderFile value) {
        this.m_Executable = value;
        this.reset();
    }

    public PlaceholderFile getExecutable() {
        return this.m_Executable;
    }

    public String executableTipText() {
        return "The full path to the jmap executable.";
    }

    public void setAdditionalOptions(String value) {
        this.m_AdditionalOptions = value;
        this.reset();
    }

    public String getAdditionalOptions() {
        return this.m_AdditionalOptions;
    }

    public String additionalOptionsTipText() {
        return "Additional options for the jmap execution.";
    }

    public void setPID(long value) {
        this.m_PID = value;
        this.reset();
    }

    public long getPID() {
        return this.m_PID;
    }

    public String PIDTipText() {
        return "The PID to monitor: use -1 to ignore monitoring or -999 to automatically determine the PID of the current JVM.";
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_ActualPID = this.m_PID;
            if (this.m_ActualPID == -999L) {
                this.m_ActualPID = ProcessUtils.getVirtualMachinePID();
            }
        }
        return result;
    }

    protected boolean canRunJMap() {
        return this.m_ActualPID != -1L;
    }

    @Override
    protected boolean canProcessInput(Token token) {
        return super.canProcessInput(token) && this.canRunJMap();
    }

    @Override
    protected Token createTeeToken(Token token) {
        String outputStr = adams.core.management.JMap.execute(this.m_Executable.getAbsolutePath(), this.m_AdditionalOptions, this.m_ActualPID);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("output: " + outputStr);
        }
        Token result = new Token(outputStr);
        return result;
    }
}

