/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.QuickInfoHelper;
import adams.core.VariableName;
import adams.core.option.OptionHandler;
import adams.event.VariableChangeEvent;
import adams.flow.control.Sequence;

public class SinkReset
extends Sequence {
    private static final long serialVersionUID = 5975989766824652946L;
    protected VariableName m_VariableName;

    @Override
    public String globalInfo() {
        return "Resets all sub-actors in case the monitored variable changed since the last execution.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("var-name", "variableName", new VariableName());
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "variableName", this.m_VariableName.paddedValue());
        if (super.getQuickInfo() != null) {
            result = result + ", " + super.getQuickInfo();
        }
        return result;
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The variable to monitor.";
    }

    @Override
    public void variableChanged(VariableChangeEvent e) {
        super.variableChanged(e);
        if (e.getType() == VariableChangeEvent.Type.MODIFIED || e.getType() == VariableChangeEvent.Type.ADDED) {
            boolean bl = this.m_SetUpSubActors = !e.getName().equals(this.m_VariableName.getValue());
            if (this.m_SetUpSubActors && this.isLoggingEnabled()) {
                this.getLogger().info("Reset required");
            }
        }
    }

    @Override
    protected String preExecute() {
        String result = super.preExecute();
        this.m_SetUpSubActors = result == null;
        return result;
    }
}

