/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.CallableActorUser;
import java.util.HashSet;
import java.util.Hashtable;

public abstract class AbstractCallableActor
extends AbstractActor
implements CallableActorUser {
    private static final long serialVersionUID = -6652513967046303107L;
    public static final String BACKUP_CALLABLEACTOR = "callable actor";
    public static final String BACKUP_CONFIGURED = "configured";
    protected CallableActorReference m_CallableName;
    protected AbstractActor m_CallableActor;
    protected boolean m_Configured;
    protected CallableActorHelper m_Helper;
    protected boolean m_Optional;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("callable", "callableName", new CallableActorReference("unknown"));
        this.m_OptionManager.add("optional", "optional", false);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_CallableActor = null;
        this.m_Configured = false;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    public void setCallableName(CallableActorReference value) {
        this.m_CallableName = value;
        this.reset();
    }

    public CallableActorReference getCallableName() {
        return this.m_CallableName;
    }

    public String callableNameTipText() {
        return "The name of the callable actor to use.";
    }

    public void setOptional(boolean value) {
        this.m_Optional = value;
        this.reset();
    }

    public boolean getOptional() {
        return this.m_Optional;
    }

    public String optionalTipText() {
        return "If enabled, then the callable actor is optional, ie no error is raised if not found, merely ignored.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "callableName", this.m_CallableName);
        result = result + QuickInfoHelper.toString((OptionHandler)this, "optional", this.m_Optional, "optional", ", ");
        return result;
    }

    protected AbstractActor findCallableActor() {
        return this.m_Helper.findCallableActorRecursive(this, this.getCallableName());
    }

    public boolean hasCallableActor() {
        return this.m_CallableActor != null;
    }

    @Override
    public AbstractActor getCallableActor() {
        return this.m_CallableActor;
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CALLABLEACTOR);
        this.pruneBackup(BACKUP_CONFIGURED);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_CallableActor != null) {
            result.put(BACKUP_CALLABLEACTOR, this.m_CallableActor);
        }
        result.put(BACKUP_CONFIGURED, this.m_Configured);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        super.restoreState(state);
        if (state.containsKey(BACKUP_CALLABLEACTOR)) {
            this.m_CallableActor = (AbstractActor)state.get(BACKUP_CALLABLEACTOR);
            state.remove(BACKUP_CALLABLEACTOR);
        }
        if (state.containsKey(BACKUP_CONFIGURED)) {
            this.m_Configured = (Boolean)state.get(BACKUP_CONFIGURED);
            state.remove(BACKUP_CONFIGURED);
        }
    }

    protected String setUpCallableActor() {
        String result = null;
        this.m_CallableActor = this.findCallableActor();
        this.m_Configured = true;
        if (this.m_CallableActor == null) {
            if (!this.m_Optional) {
                result = "Couldn't find callable actor '" + this.getCallableName() + "'!";
            } else {
                this.getLogger().info("Callable actor '" + this.getCallableName() + "' not found, ignoring.");
            }
        } else {
            HashSet<String> variables = this.findVariables(this.m_CallableActor);
            this.m_DetectedVariables.addAll(variables);
            if (this.m_DetectedVariables.size() > 0) {
                this.getVariables().addVariableChangeListener(this);
            }
            if (this.getErrorHandler() != this) {
                ActorUtils.updateErrorHandler(this.m_CallableActor, this.getErrorHandler(), this.isLoggingEnabled());
            }
        }
        return result;
    }

    @Override
    public String setUp() {
        String variable;
        String result = super.setUp();
        if (result == null && (variable = this.getOptionManager().getVariableForProperty("callableName")) == null) {
            result = this.setUpCallableActor();
        }
        return result;
    }

    protected abstract String executeCallableActor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doExecute() {
        String result = null;
        if (!this.m_Configured) {
            result = this.setUpCallableActor();
        }
        if (result == null && this.m_CallableActor != null && !this.m_CallableActor.getSkip() && !this.m_CallableActor.isStopped()) {
            AbstractActor abstractActor = this.m_CallableActor;
            synchronized (abstractActor) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Executing callable actor - start: " + this.m_CallableActor);
                }
                result = this.executeCallableActor();
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Executing callable actor - end: " + result);
                }
            }
        }
        return result;
    }

    @Override
    public boolean isFinished() {
        if (this.m_CallableActor == null) {
            return true;
        }
        return this.m_CallableActor.isFinished();
    }

    @Override
    public void stopExecution() {
        try {
            if (this.m_CallableActor != null) {
                this.m_CallableActor.notifyAll();
                this.m_CallableActor.stopExecution();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stopExecution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wrapUp() {
        if (this.m_CallableActor != null) {
            AbstractActor abstractActor = this.m_CallableActor;
            synchronized (abstractActor) {
                this.m_CallableActor.wrapUp();
            }
        }
        super.wrapUp();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.m_CallableActor != null) {
            this.m_CallableActor.cleanUp();
            this.m_CallableActor = null;
        }
    }
}

