/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.Stoppable;
import adams.core.Utils;
import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingLevelHandler;
import adams.core.logging.LoggingObject;

public abstract class RunnableWithLogging
extends LoggingObject
implements Runnable,
Stoppable,
LoggingLevelHandler {
    private static final long serialVersionUID = -5192907871210498502L;
    protected boolean m_Stopped;
    protected boolean m_Running;

    @Override
    public synchronized void setLoggingLevel(LoggingLevel value) {
        this.m_LoggingLevel = value;
        this.m_Logger = null;
    }

    protected void preRun() {
    }

    protected abstract void doRun();

    protected void postRun() {
    }

    @Override
    public void run() {
        this.m_Stopped = false;
        this.preRun();
        this.m_Running = true;
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Running...");
        }
        try {
            this.doRun();
        }
        catch (Throwable t) {
            Utils.handleException(this, "Exception occurred on run!", t);
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Finished");
        }
        this.m_Running = false;
        this.postRun();
    }

    @Override
    public void stopExecution() {
        this.m_Stopped = true;
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Stopped");
        }
    }

    public boolean isStopped() {
        return this.m_Stopped;
    }

    public boolean isRunning() {
        return this.m_Running;
    }
}

