/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.execution;

import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.execution.AbstractFlowExecutionListener;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.GraphicalFlowExecutionListener;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashSet;

public class MultiListener
extends AbstractFlowExecutionListener
implements GraphicalFlowExecutionListener {
    private static final long serialVersionUID = 2134802149210184280L;
    protected FlowExecutionListener[] m_Listeners;

    @Override
    public String globalInfo() {
        return "A meta-listener that executes all sub-listeners sequentially.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("listener", "subListeners", new FlowExecutionListener[0]);
    }

    public void setSubListeners(FlowExecutionListener[] value) {
        if (value != null) {
            this.m_Listeners = value;
            this.reset();
        } else {
            this.getLogger().severe(this.getClass().getName() + ": listener cannot be null!");
        }
    }

    public FlowExecutionListener[] getSubListeners() {
        return this.m_Listeners;
    }

    public String subListenersTipText() {
        return "The array of listeners to use.";
    }

    @Override
    public void startListening() {
        super.startListening();
        for (FlowExecutionListener l : this.m_Listeners) {
            l.startListening();
        }
    }

    @Override
    public void preInput(Actor actor, Token token) {
        for (FlowExecutionListener l : this.m_Listeners) {
            l.preInput(actor, token);
        }
    }

    @Override
    public void postInput(Actor actor) {
        for (FlowExecutionListener l : this.m_Listeners) {
            l.postInput(actor);
        }
    }

    @Override
    public void preExecute(Actor actor) {
        for (FlowExecutionListener l : this.m_Listeners) {
            l.preExecute(actor);
        }
    }

    @Override
    public void postExecute(Actor actor) {
        for (FlowExecutionListener l : this.m_Listeners) {
            l.postExecute(actor);
        }
    }

    @Override
    public void preOutput(Actor actor) {
        for (FlowExecutionListener l : this.m_Listeners) {
            l.preOutput(actor);
        }
    }

    @Override
    public void postOutput(Actor actor, Token token) {
        for (FlowExecutionListener l : this.m_Listeners) {
            l.postOutput(actor, token);
        }
    }

    @Override
    public String getListenerTitle() {
        return "Listeners";
    }

    protected String createTitle(HashSet<String> titles, String initial) {
        String result = initial;
        int count = 1;
        while (titles.contains(result)) {
            result = initial + " (" + ++count + ")";
        }
        titles.add(result);
        return result;
    }

    @Override
    public BasePanel newListenerPanel() {
        BasePanel result = new BasePanel();
        result.setLayout(new BorderLayout());
        BaseTabbedPane tabbed = new BaseTabbedPane();
        result.add((Component)tabbed, "Center");
        HashSet<String> titles = new HashSet<String>();
        boolean found = false;
        for (FlowExecutionListener l : this.m_Listeners) {
            BasePanel subpanel;
            if (!(l instanceof GraphicalFlowExecutionListener) || (subpanel = ((GraphicalFlowExecutionListener)l).newListenerPanel()) == null) continue;
            found = true;
            tabbed.addTab(this.createTitle(titles, ((GraphicalFlowExecutionListener)l).getListenerTitle()), subpanel);
        }
        if (!found) {
            return null;
        }
        return result;
    }

    @Override
    public Dimension getDefaultFrameSize() {
        Dimension result = new Dimension(0, 0);
        for (FlowExecutionListener l : this.m_Listeners) {
            if (!(l instanceof GraphicalFlowExecutionListener)) continue;
            Dimension dim = ((GraphicalFlowExecutionListener)l).getDefaultFrameSize();
            if (dim.width > result.width) {
                result.width = dim.width;
            }
            if (dim.height <= result.height) continue;
            result.height = dim.height;
        }
        if (result.width == 0) {
            result.width = 800;
        }
        if (result.height == 0) {
            result.height = 600;
        }
        return result;
    }

    @Override
    public void finishListening() {
        super.finishListening();
        for (FlowExecutionListener l : this.m_Listeners) {
            l.finishListening();
        }
    }
}

