/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.ClassLocator;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionTraversalPath;
import adams.core.option.OptionTraverser;
import adams.flow.core.AbstractActor;
import adams.flow.processor.AbstractModifyingProcessor;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;

public class ChangePath
extends AbstractModifyingProcessor {
    private static final long serialVersionUID = -3031404150902143297L;
    protected String m_OldPath;
    protected String m_OldPathLinux;
    protected boolean m_OldPathIsRegExp;
    protected String m_NewPath;

    @Override
    public String globalInfo() {
        return "Updates all paths that match the provided old path.\nIf no regular expression matching is enabled, then the paths must start with the provided old path in order to trigger the replacement.\nIf regular expression matching is enabled, the old paths must match the provided regexp. The replacement string can then also contain group references (eg $1).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("old-path", "oldPath", "");
        this.m_OptionManager.add("old-path-is-regexp", "oldPathIsRegExp", false);
        this.m_OptionManager.add("new-path", "newPath", "");
    }

    public void setOldPath(String value) {
        this.m_OldPath = value;
        this.reset();
    }

    public String getOldPath() {
        return this.m_OldPath;
    }

    public String oldPathTipText() {
        return "The old JDBC Path to replace.";
    }

    public void setOldPathIsRegExp(boolean value) {
        this.m_OldPathIsRegExp = value;
        this.reset();
    }

    public boolean getOldPathIsRegExp() {
        return this.m_OldPathIsRegExp;
    }

    public String oldPathIsRegExpTipText() {
        return "If enabled, the old path gets interpreted as regular expression; otherwise, only prefix matching is used.";
    }

    public void setNewPath(String value) {
        this.m_NewPath = value;
        this.reset();
    }

    public String getNewPath() {
        return this.m_NewPath;
    }

    public String newPathTipText() {
        return "The new path to replace the old one with.";
    }

    @Override
    protected void processActor(AbstractActor actor) {
        this.m_OldPathLinux = this.m_OldPath.startsWith("\\\\") || this.m_OldPath.startsWith("//") ? "\\\\" + this.m_OldPath.substring(2).replace("\\", "/") : this.m_OldPath;
        actor.getOptionManager().traverse(new OptionTraverser(){

            protected boolean isMatch(String path) {
                if (ChangePath.this.m_OldPathIsRegExp) {
                    return path.matches(ChangePath.this.m_OldPath) || path.matches(ChangePath.this.m_OldPathLinux);
                }
                return path.startsWith(ChangePath.this.m_OldPath) || path.startsWith(ChangePath.this.m_OldPathLinux);
            }

            protected Object update(Object obj) {
                Object result = null;
                Class<?> cls = obj.getClass();
                String str = ((File)obj).toString();
                String newStr = null;
                newStr = ChangePath.this.m_OldPathIsRegExp ? (str.matches(ChangePath.this.m_OldPath) ? str.replaceFirst(ChangePath.this.m_OldPath, ChangePath.this.m_NewPath) : str.replaceFirst(ChangePath.this.m_OldPathLinux, ChangePath.this.m_NewPath)) : (str.startsWith(ChangePath.this.m_OldPath) ? str.replace(ChangePath.this.m_OldPath, ChangePath.this.m_NewPath) : str.replace(ChangePath.this.m_OldPathLinux, ChangePath.this.m_NewPath));
                try {
                    Constructor<?> constr = cls.getConstructor(String.class);
                    result = constr.newInstance(newStr);
                }
                catch (Exception e) {
                    System.err.println("Failed to create instance of " + cls.getName() + ":");
                    e.printStackTrace();
                    result = obj;
                }
                return result;
            }

            protected Object process(Object obj) {
                if (obj instanceof File) {
                    File file = (File)obj;
                    if (!this.isMatch(file.toString())) {
                        return obj;
                    }
                    ChangePath.this.m_Modified = true;
                    return this.update(file);
                }
                return obj;
            }

            @Override
            public void handleClassOption(ClassOption option, OptionTraversalPath path) {
            }

            @Override
            public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
            }

            @Override
            public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
                if (ClassLocator.isSubclass(File.class, option.getBaseClass())) {
                    Object current = option.getCurrentValue();
                    if (option.isMultiple()) {
                        for (int i = 0; i < Array.getLength(current); ++i) {
                            Array.set(current, i, this.process(Array.get(current, i)));
                        }
                        option.setCurrentValue(current);
                    } else {
                        option.setCurrentValue(this.process(current));
                    }
                }
            }

            @Override
            public boolean canHandle(AbstractOption option) {
                return true;
            }

            @Override
            public boolean canRecurse(Class cls) {
                return true;
            }

            @Override
            public boolean canRecurse(Object obj) {
                return this.canRecurse(obj.getClass());
            }
        });
    }
}

