/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractCallableActor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.MutableActorHandler;
import adams.flow.processor.AbstractModifyingProcessor;
import adams.flow.processor.CleanUpProcessor;
import adams.flow.standalone.CallableActors;
import java.util.HashSet;

public class RemoveUnusedCallableActors
extends AbstractModifyingProcessor
implements CleanUpProcessor {
    private static final long serialVersionUID = 1634101991639994065L;
    protected CallableActorHelper m_Helper;

    @Override
    public String globalInfo() {
        return "Removes all unused callable actors. Disabled actors referencing callable actors are treated as if they were enabled. If a CallableActors actor ends up being empty, it will get removed as well.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    protected void locateCallableActors(AbstractActor actor, HashSet<String> fullNames) {
        block4: {
            if (!(actor instanceof ActorHandler)) break block4;
            ActorHandler handler = (ActorHandler)((Object)actor);
            if (handler instanceof CallableActors) {
                for (int i = 0; i < handler.size(); ++i) {
                    fullNames.add(handler.get(i).getFullName());
                }
            } else {
                for (int i = 0; i < handler.size(); ++i) {
                    this.locateCallableActors(handler.get(i), fullNames);
                }
            }
        }
    }

    protected void locateCallableActorReferences(AbstractActor actor, HashSet<String> fullNames) {
        if (actor instanceof AbstractCallableActor) {
            AbstractCallableActor reference = (AbstractCallableActor)actor;
            AbstractActor callable = this.m_Helper.findCallableActorRecursive(reference, reference.getCallableName());
            if (callable != null) {
                fullNames.add(callable.getFullName());
            }
        } else if (actor instanceof ActorHandler) {
            ActorHandler handler = (ActorHandler)((Object)actor);
            for (int i = 0; i < handler.size(); ++i) {
                this.locateCallableActorReferences(handler.get(i), fullNames);
            }
        }
    }

    protected void removeUnused(AbstractActor actor, HashSet<String> unused) {
        this.m_Modified = true;
        HashSet<CallableActors> parents = new HashSet<CallableActors>();
        for (String fullname : unused) {
            AbstractActor callable = ActorUtils.locate(fullname, actor);
            if (callable == null) {
                this.getLogger().severe("Failed to locate callable actor: " + fullname);
                continue;
            }
            CallableActors callableActors = (CallableActors)callable.getParent();
            callableActors.remove(callable.index());
            parents.add(callableActors);
        }
        for (CallableActors gactors : parents) {
            if (gactors.size() != 0) continue;
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Removing empty " + CallableActors.class.getSimpleName() + ": " + gactors.getFullName());
            }
            ((MutableActorHandler)((Object)gactors.getParent())).remove(gactors.index());
        }
    }

    @Override
    protected void processActor(AbstractActor actor) {
        HashSet<String> callable = new HashSet<String>();
        this.locateCallableActors(actor, callable);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("callable actors found: " + callable);
        }
        HashSet<String> referenced = new HashSet<String>();
        this.locateCallableActorReferences(actor, referenced);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("references found: " + referenced);
        }
        HashSet unused = (HashSet)callable.clone();
        unused.removeAll(referenced);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("unused callable actors: " + unused);
        }
        if (unused.size() > 0) {
            this.removeUnused(actor, unused);
        }
    }
}

