/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.ShallowCopySupporter;
import adams.core.io.PlaceholderFile;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.report.Report;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.UpdateableDisplayPanel;
import adams.gui.core.BasePanel;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.NullOverlay;
import adams.gui.visualization.image.selection.AbstractSelectionProcessor;
import adams.gui.visualization.image.selection.NullProcessor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ImageViewer
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = 1523870513962160664L;
    protected ImagePanel m_ImagePanel;
    protected double m_Zoom;
    protected Color m_BackgroundColor;
    protected boolean m_ShowProperties;
    protected int m_PropertiesWidth;
    protected AbstractSelectionProcessor m_SelectionProcessor;
    protected Color m_SelectionBoxColor;
    protected ImageOverlay m_ImageOverlay;

    @Override
    public String globalInfo() {
        return "Actor for displaying an image.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("zoom", "zoom", 100.0, -1.0, 1600.0);
        this.m_OptionManager.add("background-color", "backgroundColor", this.getDefaultBackgroundColor());
        this.m_OptionManager.add("show-properties", "showProperties", false);
        this.m_OptionManager.add("properties-width", "propertiesWidth", 150, 1, null);
        this.m_OptionManager.add("selection-processor", "selectionProcessor", new NullProcessor());
        this.m_OptionManager.add("selection-box-color", "selectionBoxColor", Color.GRAY);
        this.m_OptionManager.add("image-overlay", "imageOverlay", new NullOverlay());
    }

    @Override
    protected int getDefaultWidth() {
        return 640;
    }

    @Override
    protected int getDefaultHeight() {
        return 480;
    }

    protected Color getDefaultBackgroundColor() {
        return new JPanel().getBackground();
    }

    public void setZoom(double value) {
        if (value == -1.0 || value > 0.0 && value <= 1600.0) {
            this.m_Zoom = value;
            this.reset();
        } else {
            this.getLogger().warning("Zoom must -1 to fit window or 0 < x < 1600, provided: " + value);
        }
    }

    public double getZoom() {
        return this.m_Zoom;
    }

    public String zoomTipText() {
        return "The zoom level in percent.";
    }

    public void setBackgroundColor(Color value) {
        this.m_BackgroundColor = value;
        this.reset();
    }

    public Color getBackgroundColor() {
        return this.m_BackgroundColor;
    }

    public String backgroundColorTipText() {
        return "The background color to use.";
    }

    public void setShowProperties(boolean value) {
        this.m_ShowProperties = value;
        this.reset();
    }

    public boolean getShowProperties() {
        return this.m_ShowProperties;
    }

    public String showPropertiesTipText() {
        return "If enabled then the image properties get displayed.";
    }

    public void setPropertiesWidth(int value) {
        this.m_PropertiesWidth = value;
        this.reset();
    }

    public int getPropertiesWidth() {
        return this.m_PropertiesWidth;
    }

    public String propertiesWidthTipText() {
        return "The width of the properties, if displayed.";
    }

    public void setSelectionProcessor(AbstractSelectionProcessor value) {
        this.m_SelectionProcessor = value;
        this.reset();
    }

    public AbstractSelectionProcessor getSelectionProcessor() {
        return this.m_SelectionProcessor;
    }

    public String selectionProcessorTipText() {
        return "The selection processor to use.";
    }

    public void setSelectionBoxColor(Color value) {
        this.m_SelectionBoxColor = value;
        this.reset();
    }

    public Color getSelectionBoxColor() {
        return this.m_SelectionBoxColor;
    }

    public String selectionBoxColorTipText() {
        return "The color of the selection box.";
    }

    public void setImageOverlay(ImageOverlay value) {
        this.m_ImageOverlay = value;
        this.reset();
    }

    public ImageOverlay getImageOverlay() {
        return this.m_ImageOverlay;
    }

    public String imageOverlayTipText() {
        return "The image overlay to use.";
    }

    @Override
    public void clearPanel() {
        if (this.m_ImagePanel != null) {
            this.m_ImagePanel.clear();
        }
    }

    @Override
    protected BasePanel newPanel() {
        this.m_ImagePanel = new ImagePanel();
        this.m_ImagePanel.setShowProperties(this.m_ShowProperties);
        this.m_ImagePanel.setShowLog(false);
        if (this.m_ShowProperties) {
            this.m_ImagePanel.getSplitPane().getRightComponent().setMinimumSize(new Dimension(this.m_PropertiesWidth, 0));
        }
        return this.m_ImagePanel;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class, BufferedImage.class, AbstractImageContainer.class};
    }

    @Override
    protected void display(Token token) {
        if (token.getPayload() instanceof String) {
            this.m_ImagePanel.load(new PlaceholderFile((String)token.getPayload()));
        } else if (token.getPayload() instanceof File) {
            this.m_ImagePanel.load((File)token.getPayload());
        } else if (token.getPayload() instanceof BufferedImage) {
            this.m_ImagePanel.setCurrentImage((BufferedImage)token.getPayload());
        } else if (token.getPayload() instanceof AbstractImageContainer) {
            this.m_ImagePanel.setCurrentImage((AbstractImageContainer)token.getPayload());
        }
        if (this.m_Zoom == -1.0) {
            this.m_ImagePanel.setScale(this.m_Zoom);
        } else {
            this.m_ImagePanel.setScale(this.m_Zoom / 100.0);
        }
        this.m_ImagePanel.setBackgroundColor(this.m_BackgroundColor);
        if (!(this.m_SelectionProcessor instanceof NullProcessor)) {
            this.m_ImagePanel.addSelectionListener(this.m_SelectionProcessor.shallowCopy(true));
            this.m_ImagePanel.setSelectionEnabled(true);
            this.m_ImagePanel.setSelectionBoxColor(this.m_SelectionBoxColor);
        }
        if (!(this.m_ImageOverlay instanceof NullOverlay)) {
            if (this.m_ImageOverlay instanceof ShallowCopySupporter) {
                this.m_ImagePanel.addImageOverlay((ImageOverlay)((ShallowCopySupporter)((Object)this.m_ImageOverlay)).shallowCopy(true));
            } else {
                this.m_ImagePanel.addImageOverlay(this.m_ImageOverlay);
            }
        }
    }

    @Override
    protected void cleanUpGUI() {
        super.cleanUpGUI();
        if (this.m_ImagePanel != null) {
            this.m_ImagePanel.clear();
        }
    }

    @Override
    public DisplayPanel createDisplayPanel(Token token) {
        ImageViewerDisplayPanel result = new ImageViewerDisplayPanel(this);
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    @Override
    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    public static class ImageViewerDisplayPanel
    extends AbstractComponentDisplayPanel
    implements UpdateableDisplayPanel {
        private static final long serialVersionUID = -3054275069984068238L;
        protected ImageViewer m_Owner;
        protected ImagePanel m_ImagePanel;

        public ImageViewerDisplayPanel(ImageViewer owner) {
            super(owner.getClass().getName());
            this.m_Owner = owner;
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_ImagePanel = new ImagePanel();
            this.m_ImagePanel.setShowLog(false);
            this.add((Component)this.m_ImagePanel, "Center");
        }

        @Override
        public void display(Token token) {
            if (token.getPayload() instanceof String) {
                this.m_ImagePanel.load(new PlaceholderFile((String)token.getPayload()));
            } else if (token.getPayload() instanceof File) {
                this.m_ImagePanel.load((File)token.getPayload());
            } else if (token.getPayload() instanceof BufferedImage) {
                this.m_ImagePanel.setCurrentImage((BufferedImage)token.getPayload());
            } else if (token.getPayload() instanceof AbstractImageContainer) {
                this.m_ImagePanel.setCurrentImage((AbstractImageContainer)token.getPayload());
            }
            this.m_ImagePanel.setShowProperties(this.m_Owner.getShowProperties());
            if (this.m_Owner.getShowProperties()) {
                this.m_ImagePanel.getSplitPane().getRightComponent().setMinimumSize(new Dimension(this.m_Owner.getPropertiesWidth(), 0));
            }
            this.m_ImagePanel.setBackgroundColor(this.m_Owner.getBackgroundColor());
            if (!(this.m_Owner.getSelectionProcessor() instanceof NullProcessor)) {
                this.m_ImagePanel.addSelectionListener(this.m_Owner.getSelectionProcessor().shallowCopy(true));
                this.m_ImagePanel.setSelectionEnabled(true);
                this.m_ImagePanel.setSelectionBoxColor(this.m_Owner.getSelectionBoxColor());
            }
            if (!(this.m_Owner.getImageOverlay() instanceof NullOverlay)) {
                if (this.m_Owner.getImageOverlay() instanceof ShallowCopySupporter) {
                    this.m_ImagePanel.addImageOverlay((ImageOverlay)((ShallowCopySupporter)((Object)this.m_Owner.getImageOverlay())).shallowCopy(true));
                } else {
                    this.m_ImagePanel.addImageOverlay(this.m_Owner.getImageOverlay());
                }
            }
            if (this.m_Owner.getZoom() == -1.0) {
                this.m_ImagePanel.setScale(this.m_Owner.getZoom());
            } else {
                this.m_ImagePanel.setScale(this.m_Owner.getZoom() / 100.0);
            }
        }

        @Override
        public void cleanUp() {
        }

        @Override
        public void clearPanel() {
            this.m_ImagePanel.clear();
        }

        @Override
        public JComponent supplyComponent() {
            return this.m_ImagePanel;
        }

        @Override
        public Token getUpdatedToken() {
            if (this.m_ImagePanel.getCurrentImage() == null) {
                return null;
            }
            Report report = this.m_ImagePanel.getImageProperties().getClone();
            if (this.m_ImagePanel.getAdditionalProperties() != null) {
                report.mergeWith(this.m_ImagePanel.getAdditionalProperties().getClone());
            }
            BufferedImageContainer cont = new BufferedImageContainer();
            cont.setImage(this.m_ImagePanel.getCurrentImage());
            cont.setReport(report);
            return new Token(cont);
        }
    }
}

