/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.sequenceplotter;

import adams.data.container.DataPoint;
import adams.data.sequence.XYSequencePoint;
import java.util.HashMap;

public class SequencePlotPoint
extends XYSequencePoint {
    private static final long serialVersionUID = -6220735479438426204L;
    protected Double[] m_ErrorX;
    protected Double[] m_ErrorY;
    protected HashMap<String, Object> m_MetaData;

    public SequencePlotPoint() {
        this(Double.NaN, Double.NaN);
    }

    public SequencePlotPoint(double x, double y) {
        this(null, x, y);
    }

    public SequencePlotPoint(String id, double x, double y) {
        this(id, x, y, null, null);
    }

    public SequencePlotPoint(String id, double x, double y, Double[] errorX, Double[] errorY) {
        super(id, x, y);
        if (errorX != null && (errorX.length < 1 || errorX.length > 2)) {
            errorX = null;
        }
        if (errorY != null && (errorY.length < 1 || errorY.length > 2)) {
            errorY = null;
        }
        this.m_ErrorX = errorX;
        this.m_ErrorY = errorY;
        this.m_MetaData = null;
    }

    @Override
    public void assign(DataPoint other) {
        super.assign(other);
        if (other instanceof SequencePlotPoint) {
            SequencePlotPoint point = (SequencePlotPoint)other;
            this.m_ErrorX = (Double[])point.getErrorX().clone();
            this.m_ErrorY = (Double[])point.getErrorY().clone();
            this.m_MetaData = (HashMap)point.getMetaData().clone();
        }
    }

    public boolean hasErrorX() {
        return this.m_ErrorX != null;
    }

    public Double[] getErrorX() {
        return this.m_ErrorX;
    }

    public boolean hasErrorY() {
        return this.m_ErrorY != null;
    }

    public Double[] getErrorY() {
        return this.m_ErrorY;
    }

    public void setMetaData(HashMap<String, Object> value) {
        this.m_MetaData = value;
    }

    public HashMap<String, Object> getMetaData() {
        return this.m_MetaData;
    }

    public boolean hasMetaData() {
        return this.m_MetaData != null && this.m_MetaData.size() > 0;
    }
}

