/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.sequenceplotter;

import adams.data.sequence.XYSequencePoint;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SparseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.sink.sequenceplotter.AbstractMouseClickAction;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import adams.flow.sink.sequenceplotter.SequencePlotterPanel;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.CircleHitDetector;
import java.awt.Dialog;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;

public class ViewDataClickAction
extends AbstractMouseClickAction {
    private static final long serialVersionUID = -1383042782074675611L;
    protected AbstractXYSequencePointHitDetector m_HitDetector;

    @Override
    public String globalInfo() {
        return "Displays the data that the user clicked on.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("hit-detector", "hitDetector", new CircleHitDetector());
    }

    public void setHitDetector(AbstractXYSequencePointHitDetector value) {
        this.m_HitDetector = value;
        this.reset();
    }

    public AbstractXYSequencePointHitDetector getHitDetector() {
        return this.m_HitDetector;
    }

    public String hitDetectorTipText() {
        return "The hit detector to use.";
    }

    @Override
    protected void processLeftClick(SequencePlotterPanel panel, MouseEvent e) {
        if (this.m_HitDetector.getOwner() != panel.getPaintlet()) {
            this.m_HitDetector.setOwner(panel.getPaintlet());
        }
        Object located = this.m_HitDetector.locate(e);
        ArrayList<String> cols = null;
        if (located instanceof Vector) {
            Vector hits = (Vector)located;
            SpreadSheet sheet = new SpreadSheet();
            sheet.setDataRowClass(SparseDataRow.class);
            HeaderRow header = sheet.getHeaderRow();
            for (XYSequencePoint hit : hits) {
                header.addCell("x").setContent("X");
                header.addCell("y").setContent("Y");
                DataRow row = sheet.addRow();
                row.addCell("x").setContent(hit.getX());
                row.addCell("y").setContent(hit.getY());
                if (!(hit instanceof SequencePlotPoint)) continue;
                SequencePlotPoint point = (SequencePlotPoint)hit;
                if (cols == null) {
                    cols = new ArrayList<String>();
                } else {
                    cols.clear();
                }
                if (!point.hasMetaData()) continue;
                HashMap<String, Object> meta = point.getMetaData();
                cols.addAll(meta.keySet());
                Collections.sort(cols);
                for (String key : cols) {
                    header.addCell(key).setContent(key);
                    row.addCell(key).setNative(meta.get(key));
                }
            }
            if (sheet.getRowCount() > 0) {
                SpreadSheetDialog dialog = panel.getParentDialog() != null ? new SpreadSheetDialog(panel.getParentDialog(), Dialog.ModalityType.MODELESS) : new SpreadSheetDialog(panel.getParentFrame(), false);
                dialog.setDefaultCloseOperation(2);
                dialog.setTitle(panel.getTitle());
                dialog.setSize(800, 600);
                dialog.setLocationRelativeTo(panel);
                dialog.setSpreadSheet(sheet);
                dialog.setVisible(true);
            }
        }
    }

    @Override
    protected void processRightClick(SequencePlotterPanel panel, MouseEvent e) {
    }
}

