/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.source.AbstractArrayProvider;
import adams.flow.source.filesystemsearch.AbstractFileSystemSearchlet;
import adams.flow.source.filesystemsearch.FileSearch;
import java.util.List;

public class FileSystemSearch
extends AbstractArrayProvider {
    private static final long serialVersionUID = -1389714133778925327L;
    protected AbstractFileSystemSearchlet m_Search;

    @Override
    public String globalInfo() {
        return "Uses the specified search algorithm to perform a file system search and returns the located items.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("search", "search", new FileSearch());
    }

    public void setSearch(AbstractFileSystemSearchlet value) {
        this.m_Search = value;
        this.reset();
    }

    public AbstractFileSystemSearchlet getSearch() {
        return this.m_Search;
    }

    public String searchTipText() {
        return "The search algorithm to use.";
    }

    @Override
    protected Class getItemClass() {
        return String.class;
    }

    @Override
    public String outputArrayTipText() {
        return "If enabled, the files are output as array rather than as single strings.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "search", this.m_Search);
    }

    @Override
    protected String doExecute() {
        String result = null;
        this.m_Queue.clear();
        try {
            List<String> items = this.m_Search.search();
            this.m_Queue.addAll(items);
        }
        catch (Exception e) {
            result = this.handleException("Failed to perform search!", e);
        }
        return result;
    }
}

