/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.container.DataContainer;
import adams.flow.control.Storage;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUpdater;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public abstract class AbstractDataContainerAdd<T extends DataContainer>
extends AbstractTransformer
implements StorageUpdater {
    private static final long serialVersionUID = -253714973019682939L;
    protected StorageName m_StorageName;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", new StorageName());
    }

    @Override
    public boolean isUpdatingStorage() {
        return !this.getSkip();
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "storageName", this.m_StorageName);
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public abstract String storageNameTipText();

    protected abstract Class getDataContainerClass();

    @Override
    public Class[] accepts() {
        return new Class[]{this.getDataContainerClass()};
    }

    @Override
    public Class[] generates() {
        return new Class[]{this.getDataContainerClass()};
    }

    protected abstract void add(T var1, T var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doExecute() {
        String result = null;
        Storage storage = this.getStorageHandler().getStorage();
        synchronized (storage) {
            boolean added;
            DataContainer stored = null;
            if (this.getStorageHandler().getStorage().has(this.m_StorageName)) {
                stored = (DataContainer)this.getStorageHandler().getStorage().get(this.m_StorageName);
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Data container '" + this.m_StorageName + "' available from storage: " + (stored != null));
            }
            DataContainer current = (DataContainer)this.m_InputToken.getPayload();
            if (stored != null) {
                this.add(stored, current);
                added = false;
            } else {
                stored = current;
                added = false;
            }
            this.getStorageHandler().getStorage().put(this.m_StorageName, stored);
            this.m_OutputToken = new Token(stored);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Data container " + (added ? "superimposed in" : "added to") + " storage: " + this.m_StorageName);
            }
        }
        return result;
    }
}

