/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public abstract class AbstractGetReportValue
extends AbstractTransformer {
    private static final long serialVersionUID = -6237324482439105653L;
    protected AbstractField m_Field;

    @Override
    public abstract String globalInfo();

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "field", this.getDefaultField());
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "field", this.m_Field.toParseableString());
    }

    protected abstract AbstractField getDefaultField();

    public abstract String fieldTipText();

    @Override
    public abstract Class[] accepts();

    @Override
    public Class[] generates() {
        switch (this.m_Field.getDataType()) {
            case NUMERIC: {
                return new Class[]{Double.class};
            }
            case BOOLEAN: {
                return new Class[]{Boolean.class};
            }
            case STRING: {
                return new Class[]{String.class};
            }
        }
        return new Class[]{String.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        Object obj = null;
        Report report = this.m_InputToken.getPayload() instanceof ReportHandler ? ((ReportHandler)this.m_InputToken.getPayload()).getReport() : (Report)this.m_InputToken.getPayload();
        try {
            if (report != null) {
                if (report.hasValue(this.m_Field)) {
                    obj = report.getValue(this.m_Field);
                } else if (this.isLoggingEnabled()) {
                    this.getLogger().info("Field '" + this.m_Field + "' not available from report!");
                }
            } else if (this.isLoggingEnabled()) {
                this.getLogger().info("No report available: " + this.m_InputToken);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to get report value: " + this.m_Field, e);
        }
        if (obj != null) {
            switch (this.m_Field.getDataType()) {
                case NUMERIC: {
                    this.m_OutputToken = new Token(new Double(obj.toString()));
                    break;
                }
                case BOOLEAN: {
                    this.m_OutputToken = new Token(new Boolean(obj.toString()));
                    break;
                }
                case STRING: {
                    this.m_OutputToken = new Token(obj.toString());
                    break;
                }
                default: {
                    this.m_OutputToken = new Token(obj.toString());
                }
            }
        }
        return result;
    }
}

