/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUpdater;
import adams.flow.transformer.AbstractTransformer;
import java.lang.reflect.Array;
import java.util.HashSet;

public class HashSetInit
extends AbstractTransformer
implements StorageUpdater {
    private static final long serialVersionUID = 4182914190162129217L;
    protected StorageName m_StorageName;
    protected Index m_Column;

    @Override
    public String globalInfo() {
        return "Creates a hashset from a column in a spreadsheet. The hashset itself gets stored in the internal storage under the specified name.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", new StorageName("hashset"));
        this.m_OptionManager.add("column", "column", new Index("1"));
    }

    @Override
    public boolean isUpdatingStorage() {
        return !this.getSkip();
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "storageName", this.m_StorageName, "storage: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "column", this.m_Column, ", col: ");
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name for the hashset in the internal storage.";
    }

    public void setColumn(Index value) {
        this.m_Column = value;
        this.reset();
    }

    public Index getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The index of the column in the spreadsheet which values to store in the hashset.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{SpreadSheet.class, Object[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{SpreadSheet.class, Object[].class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (this.m_InputToken.getPayload() instanceof SpreadSheet) {
            SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
            int valCol = -1;
            if (sheet.getColumnCount() < 1) {
                result = "Spreadsheet must have at least 1 column, available: " + sheet.getColumnCount();
            }
            if (result == null) {
                this.m_Column.setMax(sheet.getColumnCount());
                valCol = this.m_Column.getIntIndex();
                if (valCol == -1) {
                    result = "Failed to locate column: " + this.m_Column.getIndex();
                }
            }
            if (result == null) {
                HashSet<Object> hashset = new HashSet<Object>();
                for (Row row : sheet.rows()) {
                    Object val;
                    if (!row.hasCell(valCol) || (val = row.getCell(valCol).getNative()) == null) continue;
                    hashset.add(val);
                    if (!this.isLoggingEnabled()) continue;
                    this.getLogger().info("Adding: '" + val + "'");
                }
                this.getStorageHandler().getStorage().put(this.m_StorageName, hashset);
            }
        } else {
            Object array = this.m_InputToken.getPayload();
            HashSet<Object> hashset = new HashSet<Object>();
            for (int i = 0; i < Array.getLength(array); ++i) {
                Object val = Array.get(array, i);
                hashset.add(val);
                if (!this.isLoggingEnabled()) continue;
                this.getLogger().info("Adding: '" + val + "'");
            }
        }
        if (result == null) {
            this.m_OutputToken = this.m_InputToken;
        }
        return result;
    }
}

