/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.source.Start;
import adams.flow.transformer.AbstractTransformer;
import java.lang.reflect.Array;

public class MakePlotContainer
extends AbstractTransformer {
    private static final long serialVersionUID = 2488434486963278287L;
    protected String m_PlotName;
    protected SequencePlotterContainer.ContentType m_Type;

    @Override
    public String globalInfo() {
        return "Creates a named container for the SequencePlotter actor.\nIn case of Double arrays arriving at the input, they must have length 2 for X and Y, 4 for X/Y/Y-Error (low/high) or 6 X/Y/X-Error (low-high)/Y-Error (low-high).\nInteger arrays can only have the length 2.\nIt is also possible, depending on the plotter sink setup, to use strings for x and/or y.\nIn order to force an update of the plot, overriding the current plot-updater setup, you can create a special plot container of type " + (Object)((Object)SequencePlotterContainer.ContentType.UPDATE) + " and send that to the plot (can be " + "triggered with a null-token, e.g., from a " + Start.class.getName() + " " + "source). Useful if you want to take a screenshot at a specific time, " + "but avoid costly screen refreshs.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("plot-name", "plotName", "Plot");
        this.m_OptionManager.add("type", "type", (Object)SequencePlotterContainer.ContentType.PLOT);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "plotName", this.m_PlotName.length() > 0 ? this.m_PlotName : "-unnamed-", "name: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "type", (Object)this.m_Type, ", type: ");
        return result;
    }

    public void setPlotName(String value) {
        this.m_PlotName = value;
        this.reset();
    }

    public String getPlotName() {
        return this.m_PlotName;
    }

    public String plotNameTipText() {
        return "The name for the plot.";
    }

    public void setType(SequencePlotterContainer.ContentType value) {
        this.m_Type = value;
        this.reset();
    }

    public SequencePlotterContainer.ContentType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of plot container to create.";
    }

    @Override
    public Class[] accepts() {
        if (this.m_Type == SequencePlotterContainer.ContentType.UPDATE) {
            return new Class[]{Unknown.class};
        }
        return new Class[]{Double.class, Double[].class, Integer.class, Integer[].class, String.class, String[].class, Object[].class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        SequencePlotterContainer cont = null;
        if (this.m_Type == SequencePlotterContainer.ContentType.UPDATE) {
            cont = new SequencePlotterContainer(this.m_PlotName, null, this.m_Type);
        } else if (this.m_InputToken.getPayload().getClass().isArray()) {
            Object array = this.m_InputToken.getPayload();
            int len = Array.getLength(array);
            if (len == 2) {
                cont = new SequencePlotterContainer(this.m_PlotName, (Comparable)Array.get(array, 0), (Comparable)Array.get(array, 1), this.m_Type);
            } else if (len == 4) {
                cont = new SequencePlotterContainer(this.m_PlotName, (Comparable)Array.get(array, 0), (Comparable)Array.get(array, 1), null, new Double[]{(Double)Array.get(array, 2), (Double)Array.get(array, 3)}, this.m_Type);
            } else if (len == 6) {
                cont = new SequencePlotterContainer(this.m_PlotName, (Comparable)Array.get(array, 0), (Comparable)Array.get(array, 1), new Double[]{(Double)Array.get(array, 2), (Double)Array.get(array, 3)}, new Double[]{(Double)Array.get(array, 4), (Double)Array.get(array, 5)}, this.m_Type);
            } else {
                result = "Array must have length 2, 4 or 6 (provided: " + Array.getLength(array) + ")!";
            }
        } else {
            cont = new SequencePlotterContainer(this.m_PlotName, (Comparable)this.m_InputToken.getPayload(), this.m_Type);
        }
        if (cont != null) {
            this.m_OutputToken = new Token(cont);
        }
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{SequencePlotterContainer.class};
    }
}

