/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.control.PlotContainerUpdater;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class SetPlotContainerValue
extends AbstractTransformer {
    private static final long serialVersionUID = 2488434486963278287L;
    protected PlotContainerUpdater.PlotContainerValue m_ContainerValue;
    protected BaseString m_Value;

    @Override
    public String globalInfo() {
        return "Updates a value of a plot container before it is being displayed in the SequencePlotter sink. Usually, you would attach a variable to the 'value' property of this actor, in order to update the specified value of the container with a value that you calculated somewhere else in the flow.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("container-value", "containerValue", (Object)PlotContainerUpdater.PlotContainerValue.PLOT_NAME);
        this.m_OptionManager.add("value", "value", new BaseString("Plot"));
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "containerValue", (Object)this.m_ContainerValue);
        result = result + QuickInfoHelper.toString((OptionHandler)this, "value", this.m_Value, ": ");
        return result;
    }

    public void setContainerValue(PlotContainerUpdater.PlotContainerValue value) {
        this.m_ContainerValue = value;
        this.reset();
    }

    public PlotContainerUpdater.PlotContainerValue getContainerValue() {
        return this.m_ContainerValue;
    }

    public String containerValueTipText() {
        return "The type of value to update.";
    }

    public void setValue(BaseString value) {
        this.m_Value = value;
        this.reset();
    }

    public BaseString getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The actual value to use for updating; values for " + (Object)((Object)PlotContainerUpdater.PlotContainerValue.X_VALUE) + " and " + (Object)((Object)PlotContainerUpdater.PlotContainerValue.Y_VALUE) + " get automatically parsed to doubles; " + "in case of " + (Object)((Object)PlotContainerUpdater.PlotContainerValue.PLOT_NAME) + " you can also use " + "variables in the string.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{SequencePlotterContainer.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        SequencePlotterContainer cont = (SequencePlotterContainer)this.m_InputToken.getPayload();
        SequencePlotterContainer newCont = (SequencePlotterContainer)cont.getClone();
        switch (this.m_ContainerValue) {
            case PLOT_NAME: {
                newCont.setValue("PlotName", this.getVariables().expand(this.m_Value.getValue()));
                break;
            }
            case X_VALUE: {
                double dvalue = Utils.toDouble(this.m_Value.getValue());
                newCont.setValue("X", dvalue);
                break;
            }
            case Y_VALUE: {
                double dvalue = Utils.toDouble(this.m_Value.getValue());
                newCont.setValue("Y", dvalue);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled container value: " + (Object)((Object)this.m_ContainerValue));
            }
        }
        if (newCont != null) {
            this.m_OutputToken = new Token(newCont);
        }
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{SequencePlotterContainer.class};
    }
}

