/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DateFormat;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.DateFormatString;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.util.Date;

public class Timestamp
extends AbstractTransformer {
    private static final long serialVersionUID = 1753400674063204204L;
    protected DateFormatString m_Format;
    protected transient DateFormat m_Formatter;

    @Override
    public String globalInfo() {
        return "Creates a timestamp string whenever it receives an input token.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("format", "format", this.getDefaultFormat());
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Formatter = null;
    }

    protected synchronized DateFormat getFormatter() {
        if (this.m_Formatter == null) {
            this.m_Formatter = this.m_Format.toDateFormat();
        }
        return this.m_Formatter;
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "format", !this.m_Format.isEmpty() ? this.m_Format.getValue() : null);
    }

    protected DateFormatString getDefaultFormat() {
        return new DateFormatString("yyyy-MM-dd HH:mm:ss");
    }

    public void setFormat(DateFormatString value) {
        this.m_Format = value;
        this.reset();
    }

    public DateFormatString getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The format of the timestamp to generate.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            try {
                this.getFormatter().applyPattern(this.m_Format.getValue());
            }
            catch (Exception e) {
                result = this.handleException("Failed to set pattern '" + this.m_Format + "': ", e);
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            this.m_OutputToken = new Token(this.getFormatter().format(new Date()));
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to format date: ", e);
        }
        return result;
    }
}

