/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.management.LocaleHelper;
import adams.gui.application.AbstractPreferencesPanel;
import adams.gui.core.ParameterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComboBox;

public class LocaleSettingsPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = -5325521437739323748L;
    protected ParameterPanel m_PanelParameters;
    protected JComboBox m_ComboBoxLocales;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelParameters = new ParameterPanel();
        this.add((Component)this.m_PanelParameters, "North");
        this.m_ComboBoxLocales = new JComboBox<String>(LocaleHelper.getIDs());
        this.m_PanelParameters.addParameter("_Locale", this.m_ComboBoxLocales);
        this.load();
    }

    protected void load() {
        LocaleHelper helper = LocaleHelper.getSingleton();
        helper.reload();
        this.m_ComboBoxLocales.setSelectedItem(helper.getLocale());
    }

    @Override
    public String getTitle() {
        return "Locale";
    }

    @Override
    public boolean requiresWrapper() {
        return true;
    }

    @Override
    public String activate() {
        LocaleHelper helper = LocaleHelper.getSingleton();
        if (this.m_ComboBoxLocales.getSelectedIndex() > -1) {
            helper.setLocale(LocaleHelper.getIDs()[this.m_ComboBoxLocales.getSelectedIndex()]);
        } else {
            helper.setLocale("Default");
        }
        boolean result = helper.save();
        helper.initializeLocale();
        if (result) {
            return null;
        }
        return "Failed to save locale setup!";
    }
}

