/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.Utils;
import adams.core.base.BasePassword;
import adams.core.net.ProxyHelper;
import adams.gui.application.AbstractPreferencesPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.ParameterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Proxy;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProxySettingsPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = -8502296969739181339L;
    protected BasePanel m_PanelType;
    protected JComboBox m_ComboBoxType;
    protected ParameterPanel m_PanelHttpFtp;
    protected JTextField m_TextHttpFtpHost;
    protected JSpinner m_SpinnerHttpFtpPort;
    protected JCheckBox m_CheckBoxHttpFtpAuthentication;
    protected JTextField m_TextHttpFtpUser;
    protected JPasswordField m_TextHttpFtpPassword;
    protected JCheckBox m_CheckBoxShowHttpFtpPassword;
    protected JTextField m_TextHttpFtpNoProxy;
    protected ParameterPanel m_PanelSocks;
    protected JTextField m_TextSocksHost;
    protected JSpinner m_SpinnerSocksPort;
    protected JCheckBox m_CheckBoxSocksAuthentication;
    protected JTextField m_TextSocksUser;
    protected JPasswordField m_TextSocksPassword;
    protected JCheckBox m_CheckBoxShowSocksPassword;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.m_PanelType = new BasePanel(new GridLayout(1, 2, 5, 5));
        this.add((Component)this.m_PanelType, "North");
        this.m_ComboBoxType = new JComboBox<Proxy.Type>(Proxy.Type.values());
        this.m_ComboBoxType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxySettingsPanel.this.m_PanelHttpFtp.setEnabled(ProxySettingsPanel.this.m_ComboBoxType.getSelectedItem().equals((Object)Proxy.Type.HTTP));
                boolean sel = ProxySettingsPanel.this.m_CheckBoxHttpFtpAuthentication.isSelected();
                ProxySettingsPanel.this.m_CheckBoxHttpFtpAuthentication.setSelected(!sel);
                ProxySettingsPanel.this.m_CheckBoxHttpFtpAuthentication.setSelected(sel);
                ProxySettingsPanel.this.m_PanelSocks.setEnabled(ProxySettingsPanel.this.m_ComboBoxType.getSelectedItem().equals((Object)Proxy.Type.SOCKS));
                sel = ProxySettingsPanel.this.m_CheckBoxSocksAuthentication.isSelected();
                ProxySettingsPanel.this.m_CheckBoxSocksAuthentication.setSelected(!sel);
                ProxySettingsPanel.this.m_CheckBoxSocksAuthentication.setSelected(sel);
            }
        });
        JLabel label = new JLabel("Connection");
        label.setLabelFor(this.m_ComboBoxType);
        this.m_PanelType.add(label);
        this.m_PanelType.add(this.m_ComboBoxType);
        this.m_PanelHttpFtp = new ParameterPanel();
        this.m_PanelHttpFtp.setBorder(BorderFactory.createTitledBorder("Http & Ftp"));
        this.add((Component)this.m_PanelHttpFtp, "Center");
        this.m_TextHttpFtpHost = new JTextField(15);
        this.m_PanelHttpFtp.addParameter("_Host", this.m_TextHttpFtpHost);
        this.m_SpinnerHttpFtpPort = new JSpinner();
        this.m_PanelHttpFtp.addParameter("Port", this.m_SpinnerHttpFtpPort);
        this.m_TextHttpFtpNoProxy = new JTextField(15);
        this.m_PanelHttpFtp.addParameter("No pro_xy for", this.m_TextHttpFtpNoProxy);
        this.m_CheckBoxHttpFtpAuthentication = new JCheckBox();
        this.m_CheckBoxHttpFtpAuthentication.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ProxySettingsPanel.this.m_TextHttpFtpUser.setEnabled(ProxySettingsPanel.this.m_CheckBoxHttpFtpAuthentication.isSelected() && ProxySettingsPanel.this.m_PanelHttpFtp.isEnabled());
                ProxySettingsPanel.this.m_TextHttpFtpPassword.setEnabled(ProxySettingsPanel.this.m_CheckBoxHttpFtpAuthentication.isSelected() && ProxySettingsPanel.this.m_PanelHttpFtp.isEnabled());
                ProxySettingsPanel.this.m_CheckBoxShowHttpFtpPassword.setEnabled(ProxySettingsPanel.this.m_CheckBoxHttpFtpAuthentication.isSelected() && ProxySettingsPanel.this.m_PanelHttpFtp.isEnabled());
            }
        });
        this.m_PanelHttpFtp.addParameter("Requires _authentication", this.m_CheckBoxHttpFtpAuthentication);
        this.m_TextHttpFtpUser = new JTextField(15);
        this.m_TextHttpFtpUser.setEnabled(false);
        this.m_PanelHttpFtp.addParameter("User", this.m_TextHttpFtpUser);
        this.m_TextHttpFtpPassword = new JPasswordField(15);
        this.m_TextHttpFtpPassword.setEnabled(false);
        this.m_TextHttpFtpPassword.setEchoChar('*');
        this.m_PanelHttpFtp.addParameter("Password", this.m_TextHttpFtpPassword);
        this.m_CheckBoxShowHttpFtpPassword = new JCheckBox();
        this.m_CheckBoxShowHttpFtpPassword.setSelected(false);
        this.m_CheckBoxShowHttpFtpPassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProxySettingsPanel.this.m_CheckBoxShowHttpFtpPassword.isSelected()) {
                    ProxySettingsPanel.this.m_TextHttpFtpPassword.setEchoChar('\u0000');
                } else {
                    ProxySettingsPanel.this.m_TextHttpFtpPassword.setEchoChar('*');
                }
            }
        });
        this.m_PanelHttpFtp.addParameter("Sho_w Password", this.m_CheckBoxShowHttpFtpPassword);
        this.m_PanelSocks = new ParameterPanel();
        this.m_PanelSocks.setBorder(BorderFactory.createTitledBorder("Socks"));
        this.add((Component)this.m_PanelSocks, "South");
        this.m_TextSocksHost = new JTextField(15);
        this.m_PanelSocks.addParameter("_Host", this.m_TextSocksHost);
        this.m_SpinnerSocksPort = new JSpinner();
        this.m_PanelSocks.addParameter("Port", this.m_SpinnerSocksPort);
        this.m_CheckBoxSocksAuthentication = new JCheckBox();
        this.m_CheckBoxSocksAuthentication.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ProxySettingsPanel.this.m_TextSocksUser.setEnabled(ProxySettingsPanel.this.m_CheckBoxSocksAuthentication.isSelected() && ProxySettingsPanel.this.m_PanelSocks.isEnabled());
                ProxySettingsPanel.this.m_TextSocksPassword.setEnabled(ProxySettingsPanel.this.m_CheckBoxSocksAuthentication.isSelected() && ProxySettingsPanel.this.m_PanelSocks.isEnabled());
                ProxySettingsPanel.this.m_CheckBoxShowSocksPassword.setEnabled(ProxySettingsPanel.this.m_CheckBoxSocksAuthentication.isSelected() && ProxySettingsPanel.this.m_PanelSocks.isEnabled());
            }
        });
        this.m_PanelSocks.addParameter("Requires _authentication", this.m_CheckBoxSocksAuthentication);
        this.m_TextSocksUser = new JTextField(15);
        this.m_TextSocksUser.setEnabled(false);
        this.m_PanelSocks.addParameter("User", this.m_TextSocksUser);
        this.m_TextSocksPassword = new JPasswordField(15);
        this.m_TextSocksPassword.setEnabled(false);
        this.m_TextSocksPassword.setEchoChar('*');
        this.m_PanelSocks.addParameter("Password", this.m_TextSocksPassword);
        this.m_CheckBoxShowSocksPassword = new JCheckBox();
        this.m_CheckBoxShowSocksPassword.setSelected(false);
        this.m_CheckBoxShowSocksPassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProxySettingsPanel.this.m_CheckBoxShowSocksPassword.isSelected()) {
                    ProxySettingsPanel.this.m_TextSocksPassword.setEchoChar('\u0000');
                } else {
                    ProxySettingsPanel.this.m_TextSocksPassword.setEchoChar('*');
                }
            }
        });
        this.m_PanelSocks.addParameter("Sho_w Password", this.m_CheckBoxShowSocksPassword);
        this.load();
    }

    protected void load() {
        ProxyHelper proxy = ProxyHelper.getSingleton();
        proxy.reload();
        this.m_ComboBoxType.setSelectedItem((Object)proxy.getProxyType());
        this.m_TextHttpFtpHost.setText(proxy.getHost(Proxy.Type.HTTP));
        this.m_SpinnerHttpFtpPort.setValue(proxy.getPort(Proxy.Type.HTTP));
        this.m_TextHttpFtpNoProxy.setText(Utils.flatten(proxy.getNoProxy(Proxy.Type.HTTP), ", "));
        this.m_CheckBoxHttpFtpAuthentication.setSelected(proxy.getAuthentication(Proxy.Type.HTTP));
        this.m_TextHttpFtpUser.setText(proxy.getUser(Proxy.Type.HTTP));
        this.m_TextHttpFtpPassword.setText(proxy.getPassword(Proxy.Type.HTTP).getValue());
        this.m_TextSocksHost.setText(proxy.getHost(Proxy.Type.SOCKS));
        this.m_SpinnerSocksPort.setValue(proxy.getPort(Proxy.Type.SOCKS));
        this.m_CheckBoxSocksAuthentication.setSelected(proxy.getAuthentication(Proxy.Type.SOCKS));
        this.m_TextSocksUser.setText(proxy.getUser(Proxy.Type.SOCKS));
        this.m_TextSocksPassword.setText(proxy.getPassword(Proxy.Type.SOCKS).getValue());
    }

    @Override
    public String getTitle() {
        return "Proxy";
    }

    @Override
    public boolean requiresWrapper() {
        return true;
    }

    @Override
    public String activate() {
        ProxyHelper proxy = ProxyHelper.getSingleton();
        if (this.m_ComboBoxType.getSelectedIndex() > -1) {
            proxy.setProxyType(Proxy.Type.values()[this.m_ComboBoxType.getSelectedIndex()]);
        } else {
            proxy.setProxyType(Proxy.Type.DIRECT);
        }
        proxy.setHost(Proxy.Type.HTTP, this.m_TextHttpFtpHost.getText());
        proxy.setPort(Proxy.Type.HTTP, ((Number)this.m_SpinnerHttpFtpPort.getValue()).intValue());
        proxy.setNoProxy(Proxy.Type.HTTP, this.m_TextHttpFtpNoProxy.getText().replaceAll(" ", "").split(","));
        proxy.setAuthentication(Proxy.Type.HTTP, this.m_CheckBoxHttpFtpAuthentication.isSelected());
        proxy.setUser(Proxy.Type.HTTP, this.m_TextHttpFtpUser.getText());
        proxy.setPassword(Proxy.Type.HTTP, new BasePassword(this.m_TextHttpFtpPassword.getText()));
        proxy.setHost(Proxy.Type.SOCKS, this.m_TextSocksHost.getText());
        proxy.setPort(Proxy.Type.SOCKS, ((Number)this.m_SpinnerSocksPort.getValue()).intValue());
        proxy.setAuthentication(Proxy.Type.SOCKS, this.m_CheckBoxSocksAuthentication.isSelected());
        proxy.setUser(Proxy.Type.SOCKS, this.m_TextSocksUser.getText());
        proxy.setPassword(Proxy.Type.SOCKS, new BasePassword(this.m_TextSocksPassword.getText()));
        boolean result = proxy.save();
        proxy.initializeProxy();
        if (result) {
            return null;
        }
        return "Failed to save proxy setup!";
    }
}

