/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.ExtensionFileFilter;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public abstract class AbstractExtensionFileFilterFileChooser<F extends ExtensionFileFilter>
extends BaseFileChooser {
    private static final long serialVersionUID = -1607568357690603421L;
    public static final int UNHANDLED_DIALOG = -1;
    protected int m_DialogType;
    protected Object m_CurrentHandler;
    protected PropertyChangeListener m_Listener;
    protected ExtensionFileFilter m_LastFilter;
    protected boolean m_FileMustExist;

    protected AbstractExtensionFileFilterFileChooser() {
    }

    protected AbstractExtensionFileFilterFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    protected AbstractExtensionFileFilterFileChooser(String currentDirectory) {
        super(currentDirectory);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DialogType = -1;
        super.setAcceptAllFileFilterUsed(false);
        this.setFileMustExist(true);
        this.setAutoAppendExtension(true);
        AbstractExtensionFileFilterFileChooser.initializeFilters(this);
    }

    protected abstract boolean getFiltersInitialized();

    protected abstract void doInitializeFilters();

    protected static synchronized void initializeFilters(AbstractExtensionFileFilterFileChooser chooser) {
        if (!chooser.getFiltersInitialized()) {
            chooser.doInitializeFilters();
        }
    }

    public void setFileMustExist(boolean value) {
        this.m_FileMustExist = value;
    }

    public boolean getFileMustExist() {
        return this.m_FileMustExist;
    }

    protected abstract List<F> getOpenFileFilters();

    protected abstract List<F> getSaveFileFilters();

    protected F getDefaultFileFilter(int dialogType) {
        List<F> list = dialogType == 0 ? this.getOpenFileFilters() : this.getSaveFileFilters();
        if (list.size() > 0) {
            return (F)((ExtensionFileFilter)list.get(0));
        }
        return null;
    }

    protected F restoreLastFilter(int dialogType) {
        ExtensionFileFilter result = null;
        List<F> list = dialogType == 0 ? this.getOpenFileFilters() : this.getSaveFileFilters();
        if (list.size() > 0) {
            result = (ExtensionFileFilter)this.getDefaultFileFilter(dialogType);
            this.setFileFilter(result);
            if (this.m_LastFilter != null) {
                for (int i = 0; i < list.size(); ++i) {
                    if (((ExtensionFileFilter)list.get(i)).compareTo(this.m_LastFilter) != 0) continue;
                    result = this.m_LastFilter;
                    this.setFileFilter(this.m_LastFilter);
                    break;
                }
            }
        }
        return (F)result;
    }

    protected void initGUI(int dialogType) {
        this.m_CurrentHandler = null;
        this.resetChoosableFileFilters();
        List<F> list = dialogType == 0 ? this.getOpenFileFilters() : this.getSaveFileFilters();
        for (int i = 0; i < list.size(); ++i) {
            this.addChoosableFileFilter((FileFilter)list.get(i));
        }
        this.restoreLastFilter(dialogType);
        if (this.m_Listener != null) {
            this.removePropertyChangeListener(this.m_Listener);
        }
        this.m_Listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("fileFilterChanged") && AbstractExtensionFileFilterFileChooser.this.getFileFilter() != null) {
                    AbstractExtensionFileFilterFileChooser.this.updateCurrentHandlerHook();
                }
            }
        };
        this.addPropertyChangeListener(this.m_Listener);
        if (this.getFileFilter() != null) {
            this.updateCurrentHandlerHook();
        }
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) {
        if (this.m_DialogType == -1) {
            throw new IllegalStateException("Either use showOpenDialog or showSaveDialog!");
        }
        return super.showDialog(parent, approveButtonText);
    }

    @Override
    public int getDialogType() {
        return this.m_DialogType;
    }

    @Override
    public int showOpenDialog(Component parent) {
        this.m_DialogType = 0;
        this.initGUI(0);
        int result = super.showOpenDialog(parent);
        this.m_DialogType = -1;
        this.removePropertyChangeListener(this.m_Listener);
        PlaceholderFile selFile = this.getSelectedPlaceholderFile();
        if (result == 0 && this.getFileMustExist() && selFile == null) {
            result = this.showOpenDialog(parent);
        } else if (result == 0 && this.getFileMustExist() && selFile != null && selFile.isFile() && !selFile.exists()) {
            int retVal = JOptionPane.showConfirmDialog(parent, "The file '" + selFile + "' does not exist - please select again!");
            result = retVal == 0 ? this.showOpenDialog(parent) : 1;
        }
        if (result == 0) {
            this.m_LastFilter = this.getFileFilter() instanceof ExtensionFileFilter ? (ExtensionFileFilter)this.getFileFilter() : null;
            if (this.getSelectedPlaceholderFile() != null) {
                this.configureCurrentHandlerHook(0);
            }
        }
        return result;
    }

    @Override
    public int showSaveDialog(Component parent) {
        this.m_DialogType = 1;
        this.initGUI(1);
        FileFilter currentFilter = this.getFileFilter();
        PlaceholderFile currentFile = this.getSelectedPlaceholderFile();
        this.setAcceptAllFileFilterUsed(false);
        this.setFileFilter(currentFilter);
        this.setSelectedFile(currentFile);
        int result = super.showSaveDialog(parent);
        currentFilter = this.getFileFilter();
        currentFile = this.getSelectedPlaceholderFile();
        this.setFileFilter(currentFilter);
        this.setSelectedFile(currentFile);
        this.m_DialogType = -1;
        this.removePropertyChangeListener(this.m_Listener);
        if (result == 0) {
            this.m_LastFilter = this.getFileFilter() instanceof ExtensionFileFilter ? (ExtensionFileFilter)this.getFileFilter() : null;
            if (this.getSelectedPlaceholderFile() != null) {
                this.configureCurrentHandlerHook(1);
            }
        }
        return result;
    }

    protected void updateCurrentHandlerHook() {
    }

    protected void configureCurrentHandlerHook(int dialogType) {
    }

    @Override
    public void setAcceptAllFileFilterUsed(boolean b) {
        super.setAcceptAllFileFilterUsed(false);
    }

    public boolean setCorrectOpenFileFilter(File file) {
        boolean result = false;
        String fileExt = FileUtils.getExtension(file);
        for (ExtensionFileFilter filter : this.getOpenFileFilters()) {
            for (String ext : filter.getExtensions()) {
                if (!ext.equals(fileExt)) continue;
                this.setFileFilter(filter);
                this.m_LastFilter = filter;
                result = true;
                this.updateCurrentHandlerHook();
                break;
            }
            if (!result) continue;
            break;
        }
        return result;
    }

    public boolean setCorrectSaveFileFilter(File file) {
        boolean result = false;
        String fileExt = FileUtils.getExtension(file);
        for (ExtensionFileFilter filter : this.getSaveFileFilters()) {
            for (String ext : filter.getExtensions()) {
                if (!ext.equals(fileExt)) continue;
                this.setFileFilter(filter);
                this.m_LastFilter = filter;
                result = true;
                this.updateCurrentHandlerHook();
                break;
            }
            if (!result) continue;
            break;
        }
        return result;
    }
}

