/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.DateUtils;
import adams.gui.chooser.DateProvider;
import adams.gui.core.BasePanel;
import java.awt.FlowLayout;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimePanel
extends BasePanel
implements DateProvider {
    private static final long serialVersionUID = -4509241746496910365L;
    protected JSpinner m_SpinnerHour;
    protected JSpinner m_SpinnerMinute;
    protected JSpinner m_SpinnerSecond;
    protected HashSet<ChangeListener> m_ChangeListeners;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_ChangeListeners = new HashSet();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new FlowLayout(0));
        this.m_SpinnerHour = new JSpinner(new SpinnerNumberModel(0, 0, 23, 1));
        this.m_SpinnerHour.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TimePanel.this.notifyChangeListeners();
            }
        });
        this.m_SpinnerMinute = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        this.m_SpinnerMinute.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TimePanel.this.notifyChangeListeners();
            }
        });
        this.m_SpinnerSecond = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        this.m_SpinnerSecond.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TimePanel.this.notifyChangeListeners();
            }
        });
        this.add(this.m_SpinnerHour);
        this.add(new JLabel(":"));
        this.add(this.m_SpinnerMinute);
        this.add(new JLabel(":"));
        this.add(this.m_SpinnerSecond);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.setDate(new Date());
    }

    @Override
    public void setDate(Date value) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(value);
        this.m_SpinnerHour.setValue(cal.get(11));
        this.m_SpinnerMinute.setValue(cal.get(12));
        this.m_SpinnerSecond.setValue(cal.get(13));
    }

    @Override
    public Date getDate() {
        Calendar result = DateUtils.getCalendar();
        result.set(1, 0);
        result.set(2, 0);
        result.set(5, 1);
        result.set(11, ((SpinnerNumberModel)this.m_SpinnerHour.getModel()).getNumber().intValue());
        result.set(12, ((SpinnerNumberModel)this.m_SpinnerMinute.getModel()).getNumber().intValue());
        result.set(13, ((SpinnerNumberModel)this.m_SpinnerSecond.getModel()).getNumber().intValue());
        return result.getTime();
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyChangeListeners() {
        HashSet<ChangeListener> hashSet = this.m_ChangeListeners;
        synchronized (hashSet) {
            Iterator<ChangeListener> iter = this.m_ChangeListeners.iterator();
            ChangeEvent e = new ChangeEvent(this);
            while (iter.hasNext()) {
                iter.next().stateChanged(e);
            }
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.m_SpinnerHour.setEnabled(b);
        this.m_SpinnerMinute.setEnabled(b);
        this.m_SpinnerSecond.setEnabled(b);
    }
}

