/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.io.FileUtils;
import adams.gui.core.AbstractRecentItemsHandler;
import java.io.File;
import java.util.HashSet;

public class RecentFilesHandler<M>
extends AbstractRecentItemsHandler<M, File> {
    private static final long serialVersionUID = 7532226757387619342L;
    public static final String RECENTFILES_COUNT = "RecentFilesCount";
    public static final String RECENTFILES_PREFIX = "RecentFile.";
    protected int m_MinNumParentDirs;

    public RecentFilesHandler(String propsFile, M menu) {
        super(propsFile, menu);
    }

    public RecentFilesHandler(String propsFile, int maxCount, M menu) {
        super(propsFile, maxCount, menu);
    }

    public RecentFilesHandler(String propsFile, String propPrefix, int maxCount, M menu) {
        super(propsFile, propPrefix, maxCount, menu);
    }

    @Override
    protected boolean check(File item) {
        return item.exists();
    }

    protected synchronized int determineMinimumNumberOfParentDirs() {
        HashSet<String> files;
        int i;
        int result = -1;
        int max = 0;
        for (i = 0; i < this.m_RecentItems.size(); ++i) {
            max = Math.max(max, FileUtils.getDirectoryDepth((File)this.m_RecentItems.get(i)));
        }
        int num = 0;
        do {
            files = new HashSet<String>();
            for (i = 0; i < this.m_RecentItems.size(); ++i) {
                files.add(FileUtils.createPartialFilename((File)this.m_RecentItems.get(i), num));
            }
            if (files.size() == this.m_RecentItems.size()) {
                result = num;
                continue;
            }
            ++num;
        } while (files.size() < this.m_RecentItems.size() && num <= max);
        return result;
    }

    @Override
    protected String getCountKey() {
        return RECENTFILES_COUNT;
    }

    @Override
    protected String getItemPrefix() {
        return RECENTFILES_PREFIX;
    }

    @Override
    protected String toString(File obj) {
        return obj.getAbsolutePath();
    }

    @Override
    protected File fromString(String s) {
        return new File(s);
    }

    @Override
    protected void preUpdateMenu() {
        super.preUpdateMenu();
        this.m_MinNumParentDirs = this.determineMinimumNumberOfParentDirs();
    }

    @Override
    protected String createMenuItemText(int index, File item) {
        return FileUtils.createPartialFilename(item, this.m_MinNumParentDirs);
    }
}

