/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.Utils;
import java.util.regex.Pattern;

public class SearchParameters {
    protected String m_SearchString;
    protected Integer m_Integer;
    protected Double m_Double;
    protected boolean m_RegExp;
    protected Pattern m_Pattern;

    public SearchParameters(String search) {
        this(search, false);
    }

    public SearchParameters(String search, boolean regExp) {
        this.m_RegExp = regExp;
        if (search == null) {
            search = "";
        }
        if (!this.m_RegExp) {
            this.m_SearchString = search.toLowerCase();
            this.m_Pattern = null;
        } else {
            this.m_SearchString = search;
            this.m_Pattern = Pattern.compile(search);
        }
        try {
            this.m_Integer = Integer.parseInt(this.m_SearchString);
        }
        catch (Exception e) {
            this.m_Integer = null;
        }
        try {
            this.m_Double = Utils.toDouble(this.m_SearchString);
        }
        catch (Exception e) {
            this.m_Double = null;
        }
    }

    public String getSearchString() {
        return this.m_SearchString;
    }

    public boolean isRegExp() {
        return this.m_RegExp;
    }

    public boolean isInteger() {
        return this.m_Integer != null;
    }

    public boolean isDouble() {
        return this.m_Double != null;
    }

    public boolean matches(String s) {
        if (this.m_SearchString.length() == 0) {
            return true;
        }
        if (this.m_RegExp) {
            return this.m_Pattern.matcher(s).matches();
        }
        return s.toLowerCase().indexOf(this.m_SearchString) > -1;
    }

    public boolean matches(Integer i) {
        if (this.m_Integer == null) {
            return false;
        }
        if (i == null) {
            return false;
        }
        return this.m_Integer.intValue() == i.intValue();
    }

    public boolean matches(Double d) {
        if (this.m_Double == null) {
            return false;
        }
        if (d == null) {
            return false;
        }
        return this.m_Double.doubleValue() == d.doubleValue();
    }

    public String toString() {
        return "search='" + this.getSearchString() + "', " + "regexp=" + this.isRegExp() + ", " + "integer=" + this.isInteger() + ", " + "double=" + this.isDouble();
    }
}

